/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.util;

import java.math.BigDecimal;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.obvj.performetrics.util.DurationFormat;
import net.obvj.performetrics.util.TimeUnitConverter;

public final class Duration
implements Comparable<Duration> {
    public static final Duration ZERO = new Duration(java.time.Duration.ZERO);
    public static final DurationFormat DEFAULT_FORMAT = DurationFormat.SHORTER;
    private static final String MSG_DURATION_MUST_NOT_BE_NULL = "The other duration must not be null";
    private static final String MSG_DURATION_TO_ADD_MUST_NOT_BE_NULL = "The duration to add must not be null";
    private static final String MSG_SOURCE_TIME_UNIT_MUST_NOT_BE_NULL = "The source TimeUnit must not be null";
    private static final String MSG_TARGET_TIME_UNIT_MUST_NOT_BE_NULL = "The target TimeUnit must not be null";
    private static final String MSG_FORMAT_MUST_NOT_BE_NULL = "The format must not be null";
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final long NANOS_PER_SECOND = 1000000000L;
    final java.time.Duration internalDuration;
    final long effectiveTotalSeconds;
    final int effectiveNanoseconds;

    Duration(java.time.Duration internalDuration) {
        this.internalDuration = Objects.requireNonNull(internalDuration);
        this.effectiveTotalSeconds = Duration.effectiveTotalSeconds(internalDuration);
        this.effectiveNanoseconds = (int)Duration.effectiveNanoseconds(internalDuration);
    }

    private static long effectiveTotalSeconds(java.time.Duration internalDuration) {
        long effectiveTotalSeconds = internalDuration.getSeconds();
        if (internalDuration.isNegative()) {
            if (internalDuration.getNano() > 0) {
                ++effectiveTotalSeconds;
            }
            return -effectiveTotalSeconds;
        }
        return effectiveTotalSeconds;
    }

    private static long effectiveNanoseconds(java.time.Duration internalDuration) {
        int nanos = internalDuration.getNano();
        if (nanos > 0 && internalDuration.isNegative()) {
            return 1000000000L - (long)nanos;
        }
        return nanos;
    }

    public static Duration of(long amount, TimeUnit timeUnit) {
        ChronoUnit temporalUnit = Objects.requireNonNull(timeUnit, MSG_SOURCE_TIME_UNIT_MUST_NOT_BE_NULL).toChronoUnit();
        return Duration.of(amount, temporalUnit);
    }

    public static Duration of(long amount, TemporalUnit temporalUnit) {
        java.time.Duration internalDuration = java.time.Duration.of(amount, temporalUnit);
        return new Duration(internalDuration);
    }

    public static Duration parse(String string) {
        return Duration.parse(string, DEFAULT_FORMAT);
    }

    public static Duration parse(String string, DurationFormat format) {
        Objects.requireNonNull(format, MSG_FORMAT_MUST_NOT_BE_NULL);
        return format.parse(string);
    }

    public long getHours() {
        return this.effectiveTotalSeconds / 3600L;
    }

    public int getMinutes() {
        return (int)(this.effectiveTotalSeconds % 3600L / 60L);
    }

    public int getSeconds() {
        return (int)(this.effectiveTotalSeconds % 60L);
    }

    public int getNanoseconds() {
        return this.effectiveNanoseconds;
    }

    public boolean isZero() {
        return this.internalDuration.isZero();
    }

    public boolean isNegative() {
        return this.internalDuration.isNegative();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Duration)) {
            return false;
        }
        Duration other = (Duration)object;
        return this.internalDuration.equals(other.internalDuration);
    }

    public int hashCode() {
        return Objects.hash(this.internalDuration);
    }

    public String toString() {
        return this.toString(DEFAULT_FORMAT);
    }

    public String toString(DurationFormat format) {
        return this.toString(format, true);
    }

    public String toString(DurationFormat format, boolean printLegend) {
        Objects.requireNonNull(format, MSG_FORMAT_MUST_NOT_BE_NULL);
        return format.format(this, printLegend);
    }

    public double toTimeUnit(TimeUnit timeUnit) {
        return this.toTimeUnit(timeUnit, -1);
    }

    public double toTimeUnit(TimeUnit timeUnit, int scale) {
        Objects.requireNonNull(timeUnit, MSG_TARGET_TIME_UNIT_MUST_NOT_BE_NULL);
        BigDecimal targetSeconds = this.effectiveTotalSeconds != 0L ? BigDecimal.valueOf(timeUnit.convert(this.effectiveTotalSeconds, TimeUnit.SECONDS)) : BigDecimal.ZERO;
        BigDecimal targetNanoseconds = this.effectiveNanoseconds != 0 ? this.convertNanosecondsPart(timeUnit, scale) : BigDecimal.ZERO;
        double absoluteResult = targetSeconds.add(targetNanoseconds).doubleValue();
        return this.isNegative() ? -absoluteResult : absoluteResult;
    }

    private BigDecimal convertNanosecondsPart(TimeUnit timeUnit, int scale) {
        return scale >= 0 ? BigDecimal.valueOf(TimeUnitConverter.convertAndRound(this.effectiveNanoseconds, TimeUnit.NANOSECONDS, timeUnit, scale)) : BigDecimal.valueOf(TimeUnitConverter.convertAndRound(this.effectiveNanoseconds, TimeUnit.NANOSECONDS, timeUnit));
    }

    public double toSeconds() {
        return this.toTimeUnit(TimeUnit.SECONDS, 9);
    }

    public Duration plus(Duration duration) {
        Objects.requireNonNull(duration, MSG_DURATION_TO_ADD_MUST_NOT_BE_NULL);
        return new Duration(this.internalDuration.plus(duration.internalDuration));
    }

    public Duration plus(long amount, TimeUnit timeUnit) {
        return this.plus(Duration.of(amount, timeUnit));
    }

    public static Duration sum(Duration duration1, Duration duration2) {
        Objects.requireNonNull(duration1, MSG_DURATION_TO_ADD_MUST_NOT_BE_NULL);
        return duration1.plus(duration2);
    }

    public Duration multipliedBy(long multiplicand) {
        return new Duration(this.internalDuration.multipliedBy(multiplicand));
    }

    public Duration dividedBy(long divisor) {
        return new Duration(this.internalDuration.dividedBy(divisor));
    }

    public Duration negated() {
        return this.multipliedBy(-1L);
    }

    @Override
    public int compareTo(Duration otherDuration) {
        Objects.requireNonNull(otherDuration, MSG_DURATION_MUST_NOT_BE_NULL);
        return this.internalDuration.compareTo(otherDuration.internalDuration);
    }

    java.time.Duration internal() {
        return this.internalDuration;
    }
}

