/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics;

import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.obvj.performetrics.ConversionMode;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.TimingSession;
import net.obvj.performetrics.UnmodifiableCounter;
import net.obvj.performetrics.util.Duration;

public final class UnmodifiableTimingSession
extends TimingSession {
    private final TimingSession timingSession;

    public UnmodifiableTimingSession(TimingSession timingSession) {
        super(Objects.requireNonNull(timingSession, "the TimingSession to be wrapped must not be null").getTypes());
        this.timingSession = timingSession;
    }

    private static UnsupportedOperationException unsupportedOperation(String methodName) {
        return new UnsupportedOperationException(String.format("\"%s\" not allowed (unmodifiable TimingSession)", methodName));
    }

    @Override
    public void reset() {
        throw UnmodifiableTimingSession.unsupportedOperation("reset");
    }

    @Override
    public void start() {
        throw UnmodifiableTimingSession.unsupportedOperation("start");
    }

    @Override
    public void stop() {
        throw UnmodifiableTimingSession.unsupportedOperation("stop");
    }

    @Override
    public boolean isStarted() {
        return this.timingSession.isStarted();
    }

    @Override
    public Duration elapsedTime(Counter.Type type) {
        return this.timingSession.elapsedTime(type);
    }

    @Override
    public double elapsedTime(Counter.Type type, TimeUnit timeUnit) {
        return this.timingSession.elapsedTime(type, timeUnit);
    }

    @Override
    public double elapsedTime(Counter.Type type, TimeUnit timeUnit, ConversionMode conversionMode) {
        return this.timingSession.elapsedTime(type, timeUnit, conversionMode);
    }

    @Override
    Collection<Counter> getCounters() {
        return this.timingSession.getCounters().stream().map(UnmodifiableCounter::new).collect(Collectors.toList());
    }

    @Override
    Counter getCounter(Counter.Type type) {
        return new UnmodifiableCounter(this.timingSession.getCounter(type));
    }
}

