/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics;

import java.util.concurrent.TimeUnit;
import net.obvj.performetrics.ConversionMode;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.util.Duration;

public final class UnmodifiableCounter
extends Counter {
    private final Counter counter;

    public UnmodifiableCounter(Counter counter) {
        super(counter.getType(), counter.getConversionMode());
        this.counter = counter;
    }

    private static UnsupportedOperationException unsupportedOperation(String methodName) {
        return new UnsupportedOperationException(String.format("\"%s\" not allowed (unmodifiable Counter)", methodName));
    }

    @Override
    public long getUnitsBefore() {
        return this.counter.getUnitsBefore();
    }

    @Override
    public void setUnitsBefore(long unitsBefore) {
        throw UnmodifiableCounter.unsupportedOperation("setUnitsBefore");
    }

    @Override
    public long getUnitsAfter() {
        return this.counter.getUnitsAfter();
    }

    @Override
    public void setUnitsAfter(long unitsAfter) {
        throw UnmodifiableCounter.unsupportedOperation("setUnitsAfter");
    }

    @Override
    void setUnitsBefore() {
        throw UnmodifiableCounter.unsupportedOperation("setUnitsBefore");
    }

    @Override
    void setUnitsAfter() {
        throw UnmodifiableCounter.unsupportedOperation("setUnitsAfter");
    }

    @Override
    public Duration elapsedTime() {
        return this.counter.elapsedTime();
    }

    @Override
    public double elapsedTime(TimeUnit timeUnit) {
        return this.counter.elapsedTime(timeUnit);
    }

    @Override
    public double elapsedTime(TimeUnit timeUnit, ConversionMode conversionMode) {
        return this.counter.elapsedTime(timeUnit, conversionMode);
    }

    @Override
    public String toString() {
        return this.counter.toString();
    }
}

