/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics;

import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.obvj.performetrics.ConversionMode;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.Performetrics;
import net.obvj.performetrics.TimingSession;
import net.obvj.performetrics.UnmodifiableTimingSession;
import net.obvj.performetrics.util.Duration;
import net.obvj.performetrics.util.print.PrintStyle;
import net.obvj.performetrics.util.print.PrintUtils;

public abstract class TimingSessionContainer {
    static final String MSG_TYPE_NOT_SPECIFIED = "\"{0}\" was not assigned during instantiation. Available type(s): {1}";
    static final String MSG_NOT_A_SINGLE_TYPE = "This stopwatch is keeping more than one type. Please inform a specific type for this operation.";
    static final String MSG_NO_SESSION_RECORDED = "No session recorded";
    private final List<Counter.Type> types;
    private List<TimingSession> sessions;

    protected TimingSessionContainer(List<Counter.Type> types) {
        this.types = types;
        this.reset();
    }

    protected static List<Counter.Type> asList(Counter.Type ... types) {
        return types.length > 0 ? Arrays.asList(types) : Performetrics.ALL_TYPES;
    }

    public void reset() {
        this.sessions = new ArrayList<TimingSession>();
    }

    public List<Counter.Type> getTypes() {
        return this.types;
    }

    public Map<Counter.Type, List<Counter>> getAllCountersByType() {
        EnumMap<Counter.Type, List<Counter>> enumMap = new EnumMap<Counter.Type, List<Counter>>(Counter.Type.class);
        this.types.forEach(type -> enumMap.put((Counter.Type)((Object)type), this.getCounters((Counter.Type)((Object)type))));
        return enumMap;
    }

    protected List<Counter> getCounters() {
        return this.sessions.stream().map(TimingSession::getCounters).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Counter> getCounters(Counter.Type type) {
        return this.getCountersAsStream(type).collect(Collectors.toList());
    }

    private Stream<Counter> getCountersAsStream(Counter.Type type) {
        if (this.types.contains((Object)type)) {
            return this.sessions.stream().map(session -> session.getCounter(type));
        }
        throw new IllegalArgumentException(MessageFormat.format(MSG_TYPE_NOT_SPECIFIED, new Object[]{type, this.types}));
    }

    private void checkSingleCounter() {
        if (this.types.size() != 1) {
            throw new IllegalStateException(MSG_NOT_A_SINGLE_TYPE);
        }
    }

    public Duration elapsedTime() {
        this.checkSingleCounter();
        return this.elapsedTime(this.types.get(0));
    }

    public double elapsedTime(TimeUnit timeUnit) {
        this.checkSingleCounter();
        return this.elapsedTime(this.types.get(0), timeUnit);
    }

    public double elapsedTime(TimeUnit timeUnit, ConversionMode conversionMode) {
        this.checkSingleCounter();
        return this.elapsedTime(this.types.get(0), timeUnit, conversionMode);
    }

    public Duration elapsedTime(Counter.Type type) {
        return this.getCountersAsStream(type).map(Counter::elapsedTime).reduce(Duration.ZERO, Duration::sum);
    }

    public double elapsedTime(Counter.Type type, TimeUnit timeUnit) {
        return this.getCountersAsStream(type).map(counter -> counter.elapsedTime(timeUnit)).reduce(0.0, Double::sum);
    }

    public double elapsedTime(Counter.Type type, TimeUnit timeUnit, ConversionMode conversionMode) {
        return this.getCountersAsStream(type).map(counter -> counter.elapsedTime(timeUnit, conversionMode)).reduce(0.0, Double::sum);
    }

    public void print(PrintStream printStream) {
        PrintUtils.print(this, printStream);
    }

    public void print(PrintStream printStream, PrintStyle printStyle) {
        PrintUtils.print(this, printStream, printStyle);
    }

    public void printSummary(PrintStream printStream) {
        this.printSummary(printStream, null);
    }

    public void printSummary(PrintStream printStream, PrintStyle printStyle) {
        PrintUtils.printSummary(this, printStream, printStyle);
    }

    public void printDetails(PrintStream printStream) {
        this.printDetails(printStream, null);
    }

    public void printDetails(PrintStream printStream, PrintStyle printStyle) {
        PrintUtils.printDetails(this, printStream, printStyle);
    }

    protected void startNewSession() {
        TimingSession session = new TimingSession(this.types);
        this.sessions.add(session);
        session.start();
    }

    protected void stopCurrentSession() {
        this.getLastSession().ifPresent(TimingSession::stop);
    }

    Optional<TimingSession> getLastSession() {
        return this.sessions.isEmpty() ? Optional.empty() : Optional.of(this.sessions.get(this.sessions.size() - 1));
    }

    public TimingSession lastSession() {
        return new UnmodifiableTimingSession(this.getLastSession().orElseThrow(() -> new IllegalStateException(MSG_NO_SESSION_RECORDED)));
    }

    protected List<TimingSession> getAllSessions() {
        return this.sessions;
    }

    public String toString() {
        return PrintUtils.toString(this);
    }

    public String toString(PrintStyle printStyle) {
        return PrintUtils.toString(this, printStyle);
    }
}

