/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.obvj.performetrics.ConversionMode;
import net.obvj.performetrics.config.ConfigurationHolder;
import net.obvj.performetrics.util.Duration;
import net.obvj.performetrics.util.SystemUtils;

public class Counter {
    protected static final String STRING_FORMAT = "Counter [type=%s, unitsBefore=%s, unitsAfter=%s]";
    private final Type type;
    private final ConversionMode conversionMode;
    private long unitsBefore = 0L;
    private long unitsAfter = 0L;
    private boolean unitsAfterSet = false;

    public Counter(Type type) {
        this(type, null);
    }

    public Counter(Type type, ConversionMode conversionMode) {
        this.type = Objects.requireNonNull(type, "the type must not be null");
        this.conversionMode = Counter.defaultIfNull(conversionMode, ConfigurationHolder.getConfiguration().getConversionMode());
    }

    private static <T> T defaultIfNull(T object, T defaultValue) {
        return object != null ? object : defaultValue;
    }

    public long getUnitsBefore() {
        return this.unitsBefore;
    }

    public void setUnitsBefore(long unitsBefore) {
        this.unitsBefore = unitsBefore;
    }

    public long getUnitsAfter() {
        return this.unitsAfter;
    }

    public void setUnitsAfter(long unitsAfter) {
        this.unitsAfter = unitsAfter;
        this.unitsAfterSet = true;
    }

    public Type getType() {
        return this.type;
    }

    public ConversionMode getConversionMode() {
        return this.conversionMode;
    }

    void setUnitsBefore() {
        this.setUnitsBefore(this.type.getTime());
    }

    void setUnitsAfter() {
        this.setUnitsAfter(this.type.getTime());
    }

    private long elapsedTimeNanos() {
        long tempUnitsAfter = this.unitsAfterSet ? this.unitsAfter : this.type.getTime();
        return tempUnitsAfter >= this.unitsBefore ? tempUnitsAfter - this.unitsBefore : 0L;
    }

    public Duration elapsedTime() {
        return Duration.of(this.elapsedTimeNanos(), TimeUnit.NANOSECONDS);
    }

    public double elapsedTime(TimeUnit timeUnit) {
        return this.elapsedTime(timeUnit, this.conversionMode);
    }

    public double elapsedTime(TimeUnit timeUnit, ConversionMode conversionMode) {
        long elapsedTimeNanos = this.elapsedTimeNanos();
        return timeUnit == TimeUnit.NANOSECONDS ? (double)elapsedTimeNanos : conversionMode.convert(elapsedTimeNanos, TimeUnit.NANOSECONDS, timeUnit);
    }

    public String toString() {
        return String.format(STRING_FORMAT, new Object[]{this.type, this.unitsBefore, this.unitsAfter});
    }

    public static enum Type {
        WALL_CLOCK_TIME("Wall clock time"){

            @Override
            public long getTime() {
                return SystemUtils.getWallClockTimeNanos();
            }
        }
        ,
        CPU_TIME("CPU time"){

            @Override
            public long getTime() {
                return SystemUtils.getCpuTimeNanos();
            }
        }
        ,
        USER_TIME("User time"){

            @Override
            public long getTime() {
                return SystemUtils.getUserTimeNanos();
            }
        }
        ,
        SYSTEM_TIME("System time"){

            @Override
            public long getTime() {
                return SystemUtils.getSystemTimeNanos();
            }
        };

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public abstract long getTime();
    }
}

