/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

public class SystemUtils {
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();

    private SystemUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static long getWallClockTimeMillis() {
        return System.currentTimeMillis();
    }

    public static long getWallClockTimeNanos() {
        return System.nanoTime();
    }

    public static long getCpuTimeNanos() {
        return SystemUtils.getCpuTimeNanos(THREAD_MX_BEAN);
    }

    static long getCpuTimeNanos(ThreadMXBean threadMXBean) {
        return threadMXBean.isCurrentThreadCpuTimeSupported() ? threadMXBean.getCurrentThreadCpuTime() : -1L;
    }

    public static long getUserTimeNanos() {
        return SystemUtils.getUserTimeNanos(THREAD_MX_BEAN);
    }

    public static long getUserTimeNanos(ThreadMXBean threadMXBean) {
        return threadMXBean.isCurrentThreadCpuTimeSupported() ? threadMXBean.getCurrentThreadUserTime() : -1L;
    }

    public static long getSystemTimeNanos() {
        return SystemUtils.getSystemTimeNanos(THREAD_MX_BEAN);
    }

    public static long getSystemTimeNanos(ThreadMXBean threadMXBean) {
        return threadMXBean.isCurrentThreadCpuTimeSupported() ? threadMXBean.getCurrentThreadCpuTime() - threadMXBean.getCurrentThreadUserTime() : -1L;
    }
}

