/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.util;

import java.time.format.DateTimeParseException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.obvj.performetrics.util.Duration;

public enum DurationFormat {
    FULL{

        @Override
        public String doFormat(Duration duration, boolean printLegend) {
            return String.format(MyTimeUnit.HOURS.format, duration.getHours(), duration.getMinutes(), duration.getSeconds(), duration.getNanoseconds()) + DurationFormat.legend(printLegend, MyTimeUnit.HOURS.legend);
        }

        @Override
        public Duration doParse(String string) {
            return DurationFormat.parseDurationHMS(string);
        }
    }
    ,
    SHORT{

        @Override
        public String doFormat(Duration duration, boolean printLegend) {
            if (duration.getHours() > 0L) {
                return FULL.doFormat(duration, printLegend);
            }
            if (duration.getMinutes() > 0) {
                return String.format(MyTimeUnit.MINUTES.format, duration.getMinutes(), duration.getSeconds(), duration.getNanoseconds()) + DurationFormat.legend(printLegend, MyTimeUnit.MINUTES.legend);
            }
            return String.format(MyTimeUnit.SECONDS.format, duration.getSeconds(), duration.getNanoseconds()) + DurationFormat.legend(printLegend, MyTimeUnit.SECONDS.legend);
        }

        @Override
        public Duration doParse(String string) {
            return DurationFormat.parseDurationHMS(string);
        }
    }
    ,
    SHORTER{

        @Override
        public String doFormat(Duration duration, boolean printLegend) {
            String format = 3.removeTrailingZeros(SHORT.doFormat(duration, false));
            if (!printLegend) {
                return format;
            }
            if (duration.getHours() > 0L) {
                return format + DurationFormat.legend(true, MyTimeUnit.HOURS.legend);
            }
            if (duration.getMinutes() > 0) {
                return format + DurationFormat.legend(true, MyTimeUnit.MINUTES.legend);
            }
            return format + DurationFormat.legend(true, MyTimeUnit.SECONDS.legend);
        }

        @Override
        public Duration doParse(String string) {
            return DurationFormat.parseDurationHMS(string);
        }
    }
    ,
    ISO_8601{

        @Override
        public String doFormat(Duration duration, boolean printLegend) {
            return duration.internal().toString();
        }

        @Override
        public Duration doParse(String string) {
            try {
                return new Duration(java.time.Duration.parse(string));
            }
            catch (DateTimeParseException exception) {
                throw new IllegalArgumentException(String.format(DurationFormat.MSG_UNPARSEABLE_DURATION, string), exception);
            }
        }
    }
    ,
    LINUX{
        private static final String LINUX_FORMAT = "%dm%d.%03ds";
        private final Pattern linuxPattern = Pattern.compile("^(?<minutes>\\d+)m(?<seconds>\\d+).(?<milliseconds>\\d+)s");

        @Override
        public String doFormat(Duration duration, boolean printLegend) {
            return String.format(LINUX_FORMAT, TimeUnit.SECONDS.toMinutes(duration.internal().getSeconds()), duration.getSeconds(), TimeUnit.NANOSECONDS.toMillis(duration.getNanoseconds()));
        }

        @Override
        public Duration doParse(String string) {
            Matcher matcher = this.linuxPattern.matcher(string);
            if (matcher.matches()) {
                return DurationFormat.parseDuration(matcher.group("minutes"), TimeUnit.MINUTES).plus(DurationFormat.parseDuration(matcher.group("seconds"), TimeUnit.SECONDS)).plus(DurationFormat.parseDuration(matcher.group("milliseconds"), TimeUnit.MILLISECONDS));
            }
            throw new IllegalArgumentException(String.format(DurationFormat.MSG_UNPARSEABLE_DURATION, string));
        }
    };

    private static final Pattern HMS_PATTERN;
    static final String MSG_DURATION_MUST_NOT_BE_NULL = "The duration must not be null";
    static final String MSG_UNPARSEABLE_DURATION = "Unrecognized duration: %s";

    public String format(Duration duration, boolean printLegend) {
        Objects.requireNonNull(duration, MSG_DURATION_MUST_NOT_BE_NULL);
        return this.doFormat(duration, printLegend);
    }

    abstract String doFormat(Duration var1, boolean var2);

    public Duration parse(String string) {
        Objects.requireNonNull(string);
        return this.doParse(string);
    }

    abstract Duration doParse(String var1);

    private static String legend(boolean printLegend, String legend) {
        return printLegend ? " " + legend : "";
    }

    static String removeTrailingZeros(String string) {
        StringBuilder builder = new StringBuilder(string);
        while (builder.charAt(builder.length() - 1) == '0') {
            builder.setLength(builder.length() - 1);
        }
        if (builder.charAt(builder.length() - 1) == '.') {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    static String rightPadZeros(String string, int size) {
        if (string.length() >= size) {
            return string;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(string);
        builder.setLength(size);
        return builder.toString().replace('\u0000', '0');
    }

    private static Duration parseDurationHMS(String string) {
        Matcher matcher = HMS_PATTERN.matcher(string);
        if (matcher.matches()) {
            return DurationFormat.parseDuration(matcher.group("hours"), TimeUnit.HOURS).plus(DurationFormat.parseDuration(matcher.group("minutes"), TimeUnit.MINUTES)).plus(DurationFormat.parseDuration(matcher.group("seconds"), TimeUnit.SECONDS)).plus(DurationFormat.parseNanoseconds(matcher.group("nanoseconds")));
        }
        throw new IllegalArgumentException(String.format(MSG_UNPARSEABLE_DURATION, string));
    }

    private static Duration parseDuration(String string, TimeUnit timeUnit) {
        if (string != null) {
            long value = Long.parseLong(string);
            return Duration.of(value, timeUnit);
        }
        return Duration.ZERO;
    }

    private static Duration parseNanoseconds(String string) {
        if (string != null) {
            String nanoseconds = DurationFormat.rightPadZeros(string, 9);
            return DurationFormat.parseDuration(nanoseconds, TimeUnit.NANOSECONDS);
        }
        return Duration.ZERO;
    }

    static {
        HMS_PATTERN = Pattern.compile("^(((?<hours>\\d*):)?((?<minutes>\\d*):))?(?<seconds>\\d+)([.,](?<nanoseconds>\\d+))?(.)*");
    }

    private static enum MyTimeUnit {
        HOURS("hour(s)", "%d:%02d:%02d.%09d"),
        MINUTES("minute(s)", "%d:%02d.%09d"),
        SECONDS("second(s)", "%d.%09d");

        private final String legend;
        private final String format;

        private MyTimeUnit(String legend, String format) {
            this.legend = legend;
            this.format = format;
        }
    }
}

