/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.util.print;

import java.io.PrintStream;
import net.obvj.performetrics.TimingSessionContainer;
import net.obvj.performetrics.config.ConfigurationHolder;
import net.obvj.performetrics.util.print.PrintFormat;
import net.obvj.performetrics.util.print.PrintStyle;

public class PrintUtils {
    private PrintUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void printSummary(TimingSessionContainer container, PrintStream printStream) {
        PrintUtils.printSummary(container, printStream, null);
    }

    public static void printSummary(TimingSessionContainer container, PrintStream printStream, PrintStyle printStyle) {
        PrintStyle style = printStyle != null ? printStyle : ConfigurationHolder.getConfiguration().getPrintStyleForSummary();
        printStream.print(PrintFormat.SUMMARIZED.format(container, style));
    }

    public static void printDetails(TimingSessionContainer container, PrintStream printStream) {
        PrintUtils.printDetails(container, printStream, null);
    }

    public static void printDetails(TimingSessionContainer container, PrintStream printStream, PrintStyle printStyle) {
        PrintStyle style = printStyle != null ? printStyle : ConfigurationHolder.getConfiguration().getPrintStyleForDetails();
        printStream.print(PrintFormat.DETAILED.format(container, style));
    }

    public static void print(TimingSessionContainer container, PrintStream printStream) {
        PrintUtils.print(container, printStream, null);
    }

    public static void print(TimingSessionContainer container, PrintStream printStream, PrintStyle printStyle) {
        printStream.print(PrintUtils.toString(container, printStyle));
    }

    public static String toString(TimingSessionContainer container) {
        return PrintUtils.toString(container, null);
    }

    public static String toString(TimingSessionContainer container, PrintStyle printStyle) {
        PrintStyle style = printStyle != null ? printStyle : ConfigurationHolder.getConfiguration().getPrintStyle();
        return style.toString(container);
    }
}

