/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.util.print;

import java.util.Collection;
import java.util.Map;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.TimingSessionContainer;
import net.obvj.performetrics.util.DurationFormat;
import net.obvj.performetrics.util.print.PrintFormat;
import net.obvj.performetrics.util.print.PrintStyleBuilder;

public class PrintStyle {
    public static final PrintStyle SUMMARIZED_TABLE_NO_HEADER = PrintStyle.builder(PrintFormat.SUMMARIZED).withRowFormat("%-15s  %19s").withoutHeader().withDurationFormat(DurationFormat.FULL).withoutLegends().build();
    public static final PrintStyle SUMMARIZED_TABLE_FULL = PrintStyle.builder(SUMMARIZED_TABLE_NO_HEADER).withHeader().withSimpleLine('-', 36).withAlternativeLine('=', 36).build();
    public static final PrintStyle SUMMARIZED_CSV = PrintStyle.builder(PrintFormat.SUMMARIZED).withHeader().withRowFormat("\"%s\",\"%s\"").withDurationFormat(DurationFormat.FULL).withoutLegends().build();
    public static final PrintStyle SUMMARIZED_CSV_NO_HEADER = PrintStyle.builder(SUMMARIZED_CSV).withoutHeader().build();
    public static final PrintStyle SUMMARIZED_CSV_ISO_8601 = PrintStyle.builder(SUMMARIZED_CSV).withDurationFormat(DurationFormat.ISO_8601).build();
    public static final PrintStyle SUMMARIZED_CSV_ISO_8601_NO_HEADER = PrintStyle.builder(SUMMARIZED_CSV_ISO_8601).withoutHeader().build();
    public static final PrintStyle SUMMARIZED_XML = PrintStyle.builder(PrintFormat.SUMMARIZED).withHeader("<counters>").withRowFormat("  <counter type=\"%s\">%s</counter>").withTrailer("</counters>").withDurationFormat(DurationFormat.FULL).withoutLegends().build();
    public static final PrintStyle SUMMARIZED_XML_ISO_8601 = PrintStyle.builder(SUMMARIZED_XML).withDurationFormat(DurationFormat.ISO_8601).build();
    public static final PrintStyle SUMMARIZED_YAML = PrintStyle.builder(PrintFormat.SUMMARIZED).withHeader("counters:").withRowFormat("- type: %s%n  value: '%s'").withDurationFormat(DurationFormat.FULL).withoutLegends().build();
    public static final PrintStyle SUMMARIZED_YAML_ISO_8601 = PrintStyle.builder(SUMMARIZED_YAML).withRowFormat("- type: %s%n  value: %s").withDurationFormat(DurationFormat.ISO_8601).build();
    public static final PrintStyle DETAILED_TABLE_FULL = PrintStyle.builder(PrintFormat.DETAILED).withRowFormat("%5s  %19s  %19s").withHeader().withSectionHeader("%s").withSectionSummary("TOTAL %41s").withDurationFormat(DurationFormat.FULL).withoutLegends().withSimpleLine('-', 47).withAlternativeLine('=', 47).build();
    public static final PrintStyle DETAILED_CSV = PrintStyle.builder(PrintFormat.DETAILED).withRowFormat("\"%4$s\",%1$s,\"%2$s\",\"%3$s\"").withHeader("\"%4$s\",\"Session\",\"%2$s\",\"%3$s\"").withoutSectionSummary().withDurationFormat(DurationFormat.FULL).withoutLegends().build();
    public static final PrintStyle DETAILED_CSV_NO_HEADER = PrintStyle.builder(DETAILED_CSV).withoutHeader().build();
    public static final PrintStyle DETAILED_CSV_ISO_8601 = PrintStyle.builder(DETAILED_CSV).withDurationFormat(DurationFormat.ISO_8601).build();
    public static final PrintStyle DETAILED_CSV_ISO_8601_NO_HEADER = PrintStyle.builder(DETAILED_CSV_ISO_8601).withoutHeader().build();
    public static final PrintStyle DETAILED_XML = PrintStyle.builder(PrintFormat.DETAILED).withHeader("<counters>").withSectionHeader("  <counter type=\"%s\">").withRowFormat("    <session index=\"%1$s\">%2$s</session>").withSectionSummary("    <total>%s</total>").withSectionTrailer("  </counter>").withTrailer("</counters>").withDurationFormat(DurationFormat.FULL).withoutLegends().build();
    public static final PrintStyle DETAILED_XML_ISO_8601 = PrintStyle.builder(DETAILED_XML).withDurationFormat(DurationFormat.ISO_8601).build();
    public static final PrintStyle DETAILED_YAML = PrintStyle.builder(PrintFormat.DETAILED).withHeader("counters:").withSectionHeader("- type: %s%n  sessions:").withRowFormat("  - '%2$s'").withSectionSummary("  total: '%s'").withDurationFormat(DurationFormat.FULL).withoutLegends().build();
    public static final PrintStyle DETAILED_YAML_ISO_8601 = PrintStyle.builder(DETAILED_YAML).withRowFormat("  - %2$s").withSectionSummary("  total: %s").withDurationFormat(DurationFormat.ISO_8601).build();
    public static final PrintStyle LINUX = PrintStyle.builder(PrintFormat.SUMMARIZED).withRowFormat("%-8s%s").withoutHeader().withDurationFormat(DurationFormat.LINUX).withoutLegends().withoutTypes(Counter.Type.CPU_TIME).withCustomCounterName(Counter.Type.WALL_CLOCK_TIME, "real").withCustomCounterName(Counter.Type.USER_TIME, "user").withCustomCounterName(Counter.Type.SYSTEM_TIME, "sys").build();
    private final PrintFormat printFormat;
    private final boolean printHeader;
    private final String headerFormat;
    private final boolean printTrailer;
    private final String trailerFormat;
    private final String rowFormat;
    private final String sectionHeaderFormat;
    private final boolean printSectionSummary;
    private final String sectionSummaryRowFormat;
    private final boolean printSectionTrailer;
    private final String sectionTrailerFormat;
    private final DurationFormat durationFormat;
    private final boolean printLegend;
    private final String simpleLine;
    private final String alternativeLine;
    private final Collection<Counter.Type> excludedTypes;
    private final Map<Counter.Type, String> customCounterNames;

    public static PrintStyleBuilder builder(PrintFormat printFormat) {
        return new PrintStyleBuilder(printFormat);
    }

    public static PrintStyleBuilder builder(PrintStyle source) {
        return new PrintStyleBuilder(source);
    }

    PrintStyle(PrintStyleBuilder builder) {
        this.printFormat = builder.getPrintFormat();
        this.printHeader = builder.isPrintHeader();
        this.headerFormat = builder.getHeaderFormat();
        this.printTrailer = builder.isPrintTrailer();
        this.trailerFormat = builder.getTrailerFormat();
        this.rowFormat = builder.getRowFormat();
        this.sectionHeaderFormat = builder.getSectionHeaderFormat();
        this.printSectionSummary = builder.isPrintSectionSummary();
        this.sectionSummaryRowFormat = builder.getSectionSummaryRowFormat();
        this.printSectionTrailer = builder.isPrintSectionTrailer();
        this.sectionTrailerFormat = builder.getSectionTrailerFormat();
        this.durationFormat = builder.getDurationFormat();
        this.printLegend = builder.isPrintLegend();
        this.simpleLine = builder.getSimpleLine();
        this.alternativeLine = builder.getAlternativeLine();
        this.excludedTypes = builder.getExcludedTypes();
        this.customCounterNames = builder.getCustomCounterNames();
    }

    public String toString(TimingSessionContainer container) {
        return this.printFormat.format(container, this);
    }

    PrintFormat getPrintFormat() {
        return this.printFormat;
    }

    DurationFormat getDurationFormat() {
        return this.durationFormat;
    }

    boolean isPrintLegend() {
        return this.printLegend;
    }

    boolean isPrintHeader() {
        return this.printHeader;
    }

    boolean isPrintTrailer() {
        return this.printTrailer;
    }

    boolean isPrintSectionSummary() {
        return this.printSectionSummary;
    }

    boolean isPrintSectionTrailer() {
        return this.printSectionTrailer;
    }

    String getHeaderFormat() {
        return this.headerFormat;
    }

    String getTrailerFormat() {
        return this.trailerFormat;
    }

    String getRowFormat() {
        return this.rowFormat;
    }

    String getSectionHeaderFormat() {
        return this.sectionHeaderFormat;
    }

    String getSectionSummaryRowFormat() {
        return this.sectionSummaryRowFormat;
    }

    String getSectionTrailerFormat() {
        return this.sectionTrailerFormat;
    }

    String getSimpleLine() {
        return this.simpleLine;
    }

    String getAlternativeLine() {
        return this.alternativeLine;
    }

    Collection<Counter.Type> getExcludedTypes() {
        return this.excludedTypes;
    }

    boolean isPrintable(Counter.Type type) {
        return !this.excludedTypes.contains((Object)type);
    }

    Map<Counter.Type, String> getCustomCounterNames() {
        return this.customCounterNames;
    }

    String getPrintableCounterName(Counter.Type type) {
        return this.customCounterNames.getOrDefault((Object)type, type.toString());
    }
}

