/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.obvj.performetrics.config.ConfigurationHolder;

public class TimeUnitConverter {
    private static final String MSG_SOURCE_TIME_UNIT_MUST_NOT_BE_NULL = "The source TimeUnit must not be null";
    private static final String MSG_TARGET_TIME_UNIT_MUST_NOT_BE_NULL = "The target TimeUnit must not be null";

    private TimeUnitConverter() {
        throw new IllegalStateException("Utility class");
    }

    public static double convertAndRound(long sourceDuration, TimeUnit sourceTimeUnit, TimeUnit targetTimeUnit) {
        return TimeUnitConverter.convertAndRound(sourceDuration, sourceTimeUnit, targetTimeUnit, ConfigurationHolder.getConfiguration().getScale());
    }

    public static double convertAndRound(long sourceDuration, TimeUnit sourceTimeUnit, TimeUnit targetTimeUnit, int decimalPlaces) {
        return TimeUnitConverter.round(TimeUnitConverter.convert(sourceDuration, sourceTimeUnit, targetTimeUnit), decimalPlaces);
    }

    public static double convert(long sourceDuration, TimeUnit sourceTimeUnit, TimeUnit targetTimeUnit) {
        Objects.requireNonNull(sourceTimeUnit, MSG_SOURCE_TIME_UNIT_MUST_NOT_BE_NULL);
        Objects.requireNonNull(targetTimeUnit, MSG_TARGET_TIME_UNIT_MUST_NOT_BE_NULL);
        if (sourceTimeUnit == targetTimeUnit) {
            return sourceDuration;
        }
        if (sourceTimeUnit.ordinal() < targetTimeUnit.ordinal()) {
            return (double)sourceDuration / (double)sourceTimeUnit.convert(1L, targetTimeUnit);
        }
        return targetTimeUnit.convert(sourceDuration, sourceTimeUnit);
    }

    protected static double round(double number, int decimalPlaces) {
        return BigDecimal.valueOf(number).setScale(decimalPlaces, RoundingMode.HALF_EVEN).doubleValue();
    }
}

