/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.monitors;

import java.util.List;
import java.util.Objects;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.Performetrics;
import net.obvj.performetrics.TimingSessionContainer;

public class MonitoredRunnable
extends TimingSessionContainer
implements Runnable {
    private final Runnable runnable;

    public MonitoredRunnable(Runnable runnable) {
        this(runnable, Performetrics.ALL_TYPES);
    }

    public MonitoredRunnable(Runnable runnable, Counter.Type ... types) {
        this(runnable, MonitoredRunnable.asList(types));
    }

    private MonitoredRunnable(Runnable runnable, List<Counter.Type> types) {
        super(types);
        this.runnable = runnable;
    }

    @Override
    public void run() {
        Objects.requireNonNull(this.runnable, "The target Runnable must not be null");
        super.startNewSession();
        try {
            this.runnable.run();
        }
        finally {
            super.stopCurrentSession();
        }
    }
}

