/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.monitors;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.Performetrics;
import net.obvj.performetrics.TimingSessionContainer;

public class MonitoredCallable<V>
extends TimingSessionContainer
implements Callable<V> {
    private final Callable<V> callable;

    public MonitoredCallable(Callable<V> callable) {
        this(callable, Performetrics.ALL_TYPES);
    }

    public MonitoredCallable(Callable<V> callable, Counter.Type ... types) {
        this(callable, MonitoredCallable.asList(types));
    }

    private MonitoredCallable(Callable<V> callable, List<Counter.Type> types) {
        super(types);
        this.callable = callable;
    }

    @Override
    public V call() throws Exception {
        Objects.requireNonNull(this.callable, "The target Callable must not be null");
        super.startNewSession();
        try {
            V v = this.callable.call();
            return v;
        }
        finally {
            super.stopCurrentSession();
        }
    }
}

