/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics;

import java.util.List;
import java.util.function.Supplier;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.Performetrics;
import net.obvj.performetrics.TimingSessionContainer;

public class Stopwatch
extends TimingSessionContainer {
    private static final String MSG_NOT_RUNNING = "The stopwatch is not running";
    private State state;

    public Stopwatch() {
        this(Performetrics.ALL_TYPES);
    }

    public Stopwatch(Counter.Type ... types) {
        this(Stopwatch.asList(types));
    }

    private Stopwatch(List<Counter.Type> types) {
        super(types);
    }

    public static Stopwatch createStarted() {
        return Stopwatch.createStarted(Performetrics.ALL_TYPES);
    }

    public static Stopwatch createStarted(Counter.Type ... types) {
        return Stopwatch.createStarted(() -> new Stopwatch(types));
    }

    private static Stopwatch createStarted(List<Counter.Type> types) {
        return Stopwatch.createStarted(() -> new Stopwatch(types));
    }

    private static Stopwatch createStarted(Supplier<Stopwatch> supplier) {
        Stopwatch stopwatch = supplier.get();
        stopwatch.start();
        return stopwatch;
    }

    @Override
    public void reset() {
        super.reset();
        this.state = State.STOPPED;
    }

    public void start() {
        this.state.start(this);
    }

    public void stop() {
        this.state.stop(this);
    }

    public boolean isStarted() {
        return this.state == State.RUNNING;
    }

    static enum State {
        RUNNING{

            @Override
            void start(Stopwatch stopwatch) {
                stopwatch.stopCurrentSession();
                stopwatch.startNewSession();
                stopwatch.state = RUNNING;
            }

            @Override
            void stop(Stopwatch stopwatch) {
                stopwatch.stopCurrentSession();
                stopwatch.state = STOPPED;
            }
        }
        ,
        STOPPED{

            @Override
            void start(Stopwatch stopwatch) {
                stopwatch.startNewSession();
                stopwatch.state = RUNNING;
            }

            @Override
            void stop(Stopwatch stopwatch) {
                throw new IllegalStateException(Stopwatch.MSG_NOT_RUNNING);
            }
        };


        abstract void start(Stopwatch var1);

        abstract void stop(Stopwatch var1);
    }
}

