/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.util;

import java.math.BigDecimal;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.obvj.performetrics.util.DurationFormat;
import net.obvj.performetrics.util.TimeUnitConverter;

public class Duration
implements Comparable<Duration> {
    public static final Duration ZERO = new Duration(java.time.Duration.ZERO);
    public static final DurationFormat DEFAULT_FORMAT = DurationFormat.SHORTER;
    private static final String MSG_DURATION_MUST_NOT_BE_NULL = "The other duration must not be null";
    private static final String MSG_DURATION_TO_ADD_MUST_NOT_BE_NULL = "The duration to add must not be null";
    private static final String MSG_SOURCE_TIME_UNIT_MUST_NOT_BE_NULL = "The source TimeUnit must not be null";
    private static final String MSG_TARGET_TIME_UNIT_MUST_NOT_BE_NULL = "The target TimeUnit must not be null";
    private static final String MSG_FORMAT_MUST_NOT_BE_NULL = "The format must not be null";
    private static final String MSG_AMOUNT_MUST_BE_POSITIVE = "The duration amount must be a positive value";
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private final java.time.Duration internalDuration;

    Duration(java.time.Duration internalDuration) {
        this.internalDuration = Objects.requireNonNull(internalDuration);
    }

    public static Duration of(long amount, TimeUnit timeUnit) {
        if (amount < 0L) {
            throw new IllegalArgumentException(MSG_AMOUNT_MUST_BE_POSITIVE);
        }
        Objects.requireNonNull(timeUnit, MSG_SOURCE_TIME_UNIT_MUST_NOT_BE_NULL);
        ChronoUnit chronoUnit = TimeUnitConverter.toChronoUnit(timeUnit);
        java.time.Duration internalDuration = java.time.Duration.of(amount, chronoUnit);
        return new Duration(internalDuration);
    }

    public static Duration parse(String string) {
        return Duration.parse(string, DEFAULT_FORMAT);
    }

    public static Duration parse(String string, DurationFormat format) {
        Objects.requireNonNull(format, MSG_FORMAT_MUST_NOT_BE_NULL);
        return format.parse(string);
    }

    public long getHours() {
        return this.internalDuration.getSeconds() / 3600L;
    }

    public int getMinutes() {
        return (int)(this.internalDuration.getSeconds() % 3600L / 60L);
    }

    public int getSeconds() {
        return (int)(this.internalDuration.getSeconds() % 60L);
    }

    public int getNanoseconds() {
        return this.internalDuration.getNano();
    }

    public boolean isZero() {
        return this.internalDuration.isZero();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Duration)) {
            return false;
        }
        Duration other = (Duration)object;
        return this.internalDuration.equals(other.internalDuration);
    }

    public int hashCode() {
        return Objects.hash(this.internalDuration);
    }

    public String toString() {
        return this.toString(DEFAULT_FORMAT);
    }

    public String toString(DurationFormat format) {
        return this.toString(format, true);
    }

    public String toString(DurationFormat format, boolean printLegend) {
        Objects.requireNonNull(format, MSG_FORMAT_MUST_NOT_BE_NULL);
        return format.format(this, printLegend);
    }

    public double toTimeUnit(TimeUnit timeUnit) {
        return this.toTimeUnit(timeUnit, -1);
    }

    public double toTimeUnit(TimeUnit timeUnit, int scale) {
        Objects.requireNonNull(timeUnit, MSG_TARGET_TIME_UNIT_MUST_NOT_BE_NULL);
        BigDecimal targetSeconds = this.internalDuration.getSeconds() > 0L ? BigDecimal.valueOf(timeUnit.convert(this.internalDuration.getSeconds(), TimeUnit.SECONDS)) : BigDecimal.ZERO;
        BigDecimal targetNanoseconds = this.internalDuration.getNano() > 0 ? this.convertNanosecondsPart(timeUnit, scale) : BigDecimal.ZERO;
        return targetSeconds.add(targetNanoseconds).doubleValue();
    }

    private BigDecimal convertNanosecondsPart(TimeUnit timeUnit, int scale) {
        int nanoseconds = this.internalDuration.getNano();
        return scale >= 0 ? BigDecimal.valueOf(TimeUnitConverter.convertAndRound(nanoseconds, TimeUnit.NANOSECONDS, timeUnit, scale)) : BigDecimal.valueOf(TimeUnitConverter.convertAndRound(nanoseconds, TimeUnit.NANOSECONDS, timeUnit));
    }

    public double toSeconds() {
        return this.toTimeUnit(TimeUnit.SECONDS, 9);
    }

    public Duration plus(Duration duration) {
        Objects.requireNonNull(duration, MSG_DURATION_TO_ADD_MUST_NOT_BE_NULL);
        return new Duration(this.internalDuration.plus(duration.internalDuration));
    }

    public Duration plus(long amount, TimeUnit timeUnit) {
        return this.plus(Duration.of(amount, timeUnit));
    }

    public static Duration sum(Duration duration1, Duration duration2) {
        Objects.requireNonNull(duration1, MSG_DURATION_TO_ADD_MUST_NOT_BE_NULL);
        return duration1.plus(duration2);
    }

    public Duration dividedBy(long divisor) {
        return new Duration(this.internalDuration.dividedBy(divisor));
    }

    @Override
    public int compareTo(Duration otherDuration) {
        Objects.requireNonNull(otherDuration, MSG_DURATION_MUST_NOT_BE_NULL);
        return this.internalDuration.compareTo(otherDuration.internalDuration);
    }

    java.time.Duration internal() {
        return this.internalDuration;
    }
}

