/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import net.obvj.performetrics.ConversionMode;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.TimingSession;
import net.obvj.performetrics.util.Duration;

public class UnmodifiableTimingSession
extends TimingSession {
    private final TimingSession timingSession;

    public UnmodifiableTimingSession(TimingSession timingSession) {
        this.timingSession = timingSession;
    }

    private static UnsupportedOperationException unsupportedOperation(String methodName) {
        return new UnsupportedOperationException(String.format("%s operation received on an unmodifiable TimingSession", methodName));
    }

    @Override
    public void reset() {
        throw UnmodifiableTimingSession.unsupportedOperation("reset");
    }

    @Override
    public void start() {
        throw UnmodifiableTimingSession.unsupportedOperation("start");
    }

    @Override
    public void stop() {
        throw UnmodifiableTimingSession.unsupportedOperation("stop");
    }

    @Override
    public boolean isStarted() {
        return this.timingSession.isStarted();
    }

    @Override
    public Duration elapsedTime(Counter.Type type) {
        return this.timingSession.elapsedTime(type);
    }

    @Override
    public double elapsedTime(Counter.Type type, TimeUnit timeUnit) {
        return this.timingSession.elapsedTime(type, timeUnit);
    }

    @Override
    public double elapsedTime(Counter.Type type, TimeUnit timeUnit, ConversionMode conversionMode) {
        return this.timingSession.elapsedTime(type, timeUnit, conversionMode);
    }

    @Override
    Counter.Type[] getTypes() {
        return this.timingSession.getTypes();
    }

    @Override
    Collection<Counter> getCounters() {
        return this.timingSession.getCounters();
    }

    @Override
    Counter getCounter(Counter.Type type) {
        return this.timingSession.getCounter(type);
    }
}

