/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.obvj.performetrics.ConversionMode;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.util.Duration;

public class TimingSession {
    private static final String MSG_NOT_STARTED = "The timing session is not started";
    private static final String MSG_ALREADY_STARTED = "The timing session is already started";
    private static final String MSG_ALREADY_FINISHED = "A finished timing session cannot be restarted";
    private static final String MSG_TYPE_NOT_SPECIFIED = "\"{0}\" was not specified in this timing session. Available type(s): {1}";
    private static final Counter.Type[] DEFAULT_TYPES = Counter.Type.values();
    private final Counter.Type[] types;
    private Map<Counter.Type, Counter> counters;
    private State state;

    public TimingSession() {
        this(DEFAULT_TYPES);
    }

    public TimingSession(Counter.Type ... types) {
        this.types = types;
        this.doReset();
    }

    public void reset() {
        this.doReset();
    }

    private void doReset() {
        this.counters = new EnumMap<Counter.Type, Counter>(Counter.Type.class);
        for (Counter.Type type : this.types) {
            this.counters.put(type, new Counter(type));
        }
        this.state = State.READY;
    }

    public void start() {
        this.state.start(this);
    }

    public void stop() {
        this.state.stop(this);
    }

    public boolean isStarted() {
        return this.state == State.STARTED;
    }

    public Duration elapsedTime(Counter.Type type) {
        return this.getCounter(type).elapsedTime();
    }

    public double elapsedTime(Counter.Type type, TimeUnit timeUnit) {
        return this.getCounter(type).elapsedTime(timeUnit);
    }

    public double elapsedTime(Counter.Type type, TimeUnit timeUnit, ConversionMode conversionMode) {
        return this.getCounter(type).elapsedTime(timeUnit, conversionMode);
    }

    Counter.Type[] getTypes() {
        return this.types;
    }

    Collection<Counter> getCounters() {
        return this.counters.values();
    }

    Counter getCounter(Counter.Type type) {
        if (!this.counters.containsKey((Object)type)) {
            throw new IllegalArgumentException(MessageFormat.format(MSG_TYPE_NOT_SPECIFIED, new Object[]{type, this.counters.keySet()}));
        }
        return this.counters.get((Object)type);
    }

    private void doStart() {
        for (Counter counter : this.counters.values()) {
            counter.setUnitsBefore();
        }
        this.state = State.STARTED;
    }

    private void doStop() {
        for (Counter counter : this.counters.values()) {
            counter.setUnitsAfter();
        }
        this.state = State.FINISHED;
    }

    private static enum State {
        READY{

            @Override
            void start(TimingSession session) {
                session.doStart();
            }

            @Override
            void stop(TimingSession session) {
                throw new IllegalStateException(TimingSession.MSG_NOT_STARTED);
            }
        }
        ,
        STARTED{

            @Override
            void start(TimingSession session) {
                throw new IllegalStateException(TimingSession.MSG_ALREADY_STARTED);
            }

            @Override
            void stop(TimingSession session) {
                session.doStop();
            }
        }
        ,
        FINISHED{

            @Override
            void start(TimingSession session) {
                throw new IllegalStateException(TimingSession.MSG_ALREADY_FINISHED);
            }

            @Override
            void stop(TimingSession session) {
                throw new IllegalStateException(TimingSession.MSG_NOT_STARTED);
            }
        };


        abstract void start(TimingSession var1);

        abstract void stop(TimingSession var1);
    }
}

