/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.util.print;

import java.io.PrintStream;
import net.obvj.performetrics.Stopwatch;
import net.obvj.performetrics.config.ConfigurationHolder;
import net.obvj.performetrics.util.print.PrintFormat;
import net.obvj.performetrics.util.print.PrintStyle;

public class PrintUtils {
    private PrintUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void printSummary(Stopwatch stopwatch, PrintStream printStream) {
        PrintUtils.printSummary(stopwatch, printStream, null);
    }

    public static void printSummary(Stopwatch stopwatch, PrintStream printStream, PrintStyle printStyle) {
        printStream.print(PrintUtils.summaryToString(stopwatch, printStyle));
    }

    public static void printDetails(Stopwatch stopwatch, PrintStream printStream) {
        PrintUtils.printDetails(stopwatch, printStream, null);
    }

    public static void printDetails(Stopwatch stopwatch, PrintStream printStream, PrintStyle printStyle) {
        PrintStyle style = printStyle != null ? printStyle : ConfigurationHolder.getConfiguration().getPrintStyleForDetails();
        printStream.print(PrintFormat.DETAILED.format(stopwatch, style));
    }

    public static String summaryToString(Stopwatch stopwatch) {
        return PrintUtils.summaryToString(stopwatch, null);
    }

    public static String summaryToString(Stopwatch stopwatch, PrintStyle printStyle) {
        PrintStyle style = printStyle != null ? printStyle : ConfigurationHolder.getConfiguration().getPrintStyleForSummary();
        return PrintFormat.SUMMARIZED.format(stopwatch, style);
    }
}

