/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.util;

import net.obvj.performetrics.util.Duration;

public enum DurationFormat {
    FULL{

        @Override
        public String format(Duration duration, boolean printLegend) {
            return String.format(TimeUnit.HOURS.format, duration.getHours(), duration.getMinutes(), duration.getSeconds(), duration.getNanoseconds()) + DurationFormat.legend(printLegend, TimeUnit.HOURS.legend);
        }
    }
    ,
    SHORT{

        @Override
        public String format(Duration duration, boolean printLegend) {
            if (duration.getHours() > 0L) {
                return FULL.format(duration, printLegend);
            }
            if (duration.getMinutes() > 0) {
                return String.format(TimeUnit.MINUTES.format, duration.getMinutes(), duration.getSeconds(), duration.getNanoseconds()) + DurationFormat.legend(printLegend, TimeUnit.MINUTES.legend);
            }
            return String.format(TimeUnit.SECONDS.format, duration.getSeconds(), duration.getNanoseconds()) + DurationFormat.legend(printLegend, TimeUnit.SECONDS.legend);
        }
    }
    ,
    SHORTER{

        @Override
        public String format(Duration duration, boolean printLegend) {
            String format = 3.removeTrailingZeros(SHORT.format(duration, false));
            if (!printLegend) {
                return format;
            }
            if (duration.getHours() > 0L) {
                return format + DurationFormat.legend(true, TimeUnit.HOURS.legend);
            }
            if (duration.getMinutes() > 0) {
                return format + DurationFormat.legend(true, TimeUnit.MINUTES.legend);
            }
            return format + DurationFormat.legend(true, TimeUnit.SECONDS.legend);
        }
    }
    ,
    ISO_8601{

        @Override
        public String format(Duration duration, boolean printLegend) {
            return duration.getInternalDuration().toString();
        }
    };


    public abstract String format(Duration var1, boolean var2);

    private static String legend(boolean printLegend, String legend) {
        return printLegend ? " " + legend : "";
    }

    static String removeTrailingZeros(String string) {
        StringBuilder builder = new StringBuilder(string);
        while (builder.charAt(builder.length() - 1) == '0') {
            builder.setLength(builder.length() - 1);
        }
        if (builder.charAt(builder.length() - 1) == '.') {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    private static enum TimeUnit {
        HOURS("hour(s)", "%d:%02d:%02d.%09d"),
        MINUTES("minute(s)", "%d:%02d.%09d"),
        SECONDS("second(s)", "%d.%09d");

        private final String legend;
        private final String format;

        private TimeUnit(String legend, String format) {
            this.legend = legend;
            this.format = format;
        }
    }
}

