/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.monitors;

import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.obvj.performetrics.ConversionMode;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.Stopwatch;
import net.obvj.performetrics.util.Duration;
import net.obvj.performetrics.util.print.PrintStyle;
import net.obvj.performetrics.util.print.PrintUtils;

public abstract class MonitoredOperation {
    protected static final Counter.Type[] NO_SPECIFIC_TYPE = new Counter.Type[0];
    protected Stopwatch stopwatch;

    protected MonitoredOperation(Counter.Type ... types) {
        this.stopwatch = types.length > 0 ? new Stopwatch(types) : new Stopwatch();
    }

    protected List<Counter.Type> getTypes() {
        return this.stopwatch.getTypes();
    }

    public List<Counter> getCounters(Counter.Type type) {
        return this.stopwatch.getCounters(type);
    }

    public Duration elapsedTime() {
        return this.stopwatch.elapsedTime();
    }

    public double elapsedTime(TimeUnit timeUnit) {
        return this.stopwatch.elapsedTime(timeUnit);
    }

    public double elapsedTime(TimeUnit timeUnit, ConversionMode conversionMode) {
        return this.stopwatch.elapsedTime(timeUnit, conversionMode);
    }

    public Duration elapsedTime(Counter.Type type) {
        return this.stopwatch.elapsedTime(type);
    }

    public double elapsedTime(Counter.Type type, TimeUnit timeUnit) {
        return this.stopwatch.elapsedTime(type, timeUnit);
    }

    public double elapsedTime(Counter.Type type, TimeUnit timeUnit, ConversionMode conversionMode) {
        return this.stopwatch.elapsedTime(type, timeUnit, conversionMode);
    }

    public void printSummary(PrintStream printStream) {
        this.printSummary(printStream, null);
    }

    public void printSummary(PrintStream printStream, PrintStyle printStyle) {
        PrintUtils.printSummary(this.stopwatch, printStream, printStyle);
    }

    public void printDetails(PrintStream printStream) {
        this.printDetails(printStream, null);
    }

    public void printDetails(PrintStream printStream, PrintStyle printStyle) {
        PrintUtils.printDetails(this.stopwatch, printStream, printStyle);
    }

    public Map<Counter.Type, List<Counter>> getAllCountersByType() {
        return this.stopwatch.getAllCountersByType();
    }

    public void reset() {
        this.stopwatch.reset();
    }

    public String toString() {
        return this.stopwatch.toString();
    }
}

