/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.monitors;

import java.util.Objects;
import java.util.concurrent.Callable;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.monitors.MonitoredOperation;

public class MonitoredCallable<V>
extends MonitoredOperation
implements Callable<V> {
    private Callable<V> callable;

    public MonitoredCallable(Callable<V> callable) {
        this(callable, NO_SPECIFIC_TYPE);
    }

    public MonitoredCallable(Callable<V> callable, Counter.Type ... types) {
        super(types);
        this.callable = callable;
    }

    @Override
    public V call() throws Exception {
        Objects.requireNonNull(this.callable, "The target Callable must not be null");
        this.stopwatch.start();
        try {
            V v = this.callable.call();
            return v;
        }
        finally {
            this.stopwatch.stop();
        }
    }
}

