/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.config;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.obvj.performetrics.ConversionMode;
import net.obvj.performetrics.util.print.PrintStyle;

public class Configuration {
    protected static final TimeUnit INITIAL_TIME_UNIT = TimeUnit.NANOSECONDS;
    protected static final ConversionMode INITIAL_CONVERSION_MODE = ConversionMode.DOUBLE_PRECISION;
    protected static final int INITIAL_SCALE = 9;
    protected static final PrintStyle INITIAL_PRINT_STYLE_FOR_SUMMARY = PrintStyle.SUMMARIZED_TABLE_FULL;
    protected static final PrintStyle INITIAL_PRINT_STYLE_FOR_DETAILS = PrintStyle.DETAILED_TABLE_FULL;
    private static final String MSG_PRINT_STYLE_MUST_NOT_BE_NULL = "The default PrintStyle must not be null";
    private TimeUnit timeUnit = INITIAL_TIME_UNIT;
    private ConversionMode conversionMode = INITIAL_CONVERSION_MODE;
    private int scale = 9;
    private PrintStyle printStyleForSummary = INITIAL_PRINT_STYLE_FOR_SUMMARY;
    private PrintStyle printStyleForDetails = INITIAL_PRINT_STYLE_FOR_DETAILS;

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = Objects.requireNonNull(timeUnit, "the default time unit must not be null");
    }

    public ConversionMode getConversionMode() {
        return this.conversionMode;
    }

    public void setConversionMode(ConversionMode conversionMode) {
        this.conversionMode = Objects.requireNonNull(conversionMode, "the default conversion mode must not be null");
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        if (scale < 0 || scale > 16) {
            throw new IllegalArgumentException("The scale must be a number between 0 and 16");
        }
        this.scale = scale;
    }

    public PrintStyle getPrintStyleForSummary() {
        return this.printStyleForSummary;
    }

    public void setPrintStyleForSummary(PrintStyle printStyle) {
        this.printStyleForSummary = Objects.requireNonNull(printStyle, MSG_PRINT_STYLE_MUST_NOT_BE_NULL);
    }

    public PrintStyle getPrintStyleForDetails() {
        return this.printStyleForDetails;
    }

    public void setPrintStyleForDetails(PrintStyle printStyle) {
        this.printStyleForDetails = Objects.requireNonNull(printStyle, MSG_PRINT_STYLE_MUST_NOT_BE_NULL);
    }
}

