/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.util.print;

import java.util.Objects;
import net.obvj.performetrics.util.DurationFormat;
import net.obvj.performetrics.util.DurationFormatter;
import net.obvj.performetrics.util.print.PrintFormat;
import net.obvj.performetrics.util.print.PrintStyle;

public class PrintStyleBuilder {
    protected static final String DEFAULT_FORMAT = "%s";
    private final PrintFormat printFormat;
    private boolean printHeader;
    private String headerFormat;
    private String rowFormat;
    private String sectionHeaderFormat;
    private boolean printSectionSummary;
    private String sectionSummaryRowFormat;
    private DurationFormat durationFormat;
    private boolean printLegend;
    private String simpleLine;
    private String alternativeLine;

    public PrintStyleBuilder(PrintFormat printFormat) {
        this.printFormat = Objects.requireNonNull(printFormat, "The target PrintFormat must not be null");
    }

    public PrintStyleBuilder(PrintStyle source) {
        Objects.requireNonNull(source, "The base PrintStyle must not be null");
        this.printFormat = source.getPrintFormat();
        this.printHeader = source.isPrintHeader();
        this.headerFormat = source.getHeaderFormat();
        this.rowFormat = source.getRowFormat();
        this.sectionHeaderFormat = source.getSectionHeaderFormat();
        this.printSectionSummary = source.isPrintSectionSummary();
        this.sectionSummaryRowFormat = source.getSectionSummaryRowFormat();
        this.durationFormat = source.getDurationFormat();
        this.printLegend = source.isPrintLegend();
        this.simpleLine = source.getSimpleLine();
        this.alternativeLine = source.getAlternativeLine();
    }

    public PrintStyleBuilder withRowFormat(String format) {
        this.rowFormat = format;
        return this;
    }

    public PrintStyleBuilder withHeader() {
        this.printHeader = true;
        return this;
    }

    public PrintStyleBuilder withHeader(String format) {
        this.printHeader = true;
        this.headerFormat = format;
        return this;
    }

    public PrintStyleBuilder withoutHeader() {
        this.printHeader = false;
        return this;
    }

    public PrintStyleBuilder withSectionHeaderFormat(String format) {
        this.sectionHeaderFormat = format;
        return this;
    }

    public PrintStyleBuilder withoutSectionSummary() {
        this.printSectionSummary = false;
        return this;
    }

    public PrintStyleBuilder withSectionSummary(String format) {
        this.printSectionSummary = true;
        this.sectionSummaryRowFormat = format;
        return this;
    }

    public PrintStyleBuilder withSimpleLine(char character, int length) {
        return this.withSimpleLine(PrintStyleBuilder.generateLine(character, length));
    }

    public PrintStyleBuilder withSimpleLine(String string) {
        this.simpleLine = string;
        return this;
    }

    public PrintStyleBuilder withAlternativeLine(char character, int length) {
        return this.withAlternativeLine(PrintStyleBuilder.generateLine(character, length));
    }

    public PrintStyleBuilder withAlternativeLine(String string) {
        this.alternativeLine = string;
        return this;
    }

    public PrintStyleBuilder withDurationFormat(DurationFormat format) {
        this.durationFormat = format;
        return this;
    }

    public PrintStyleBuilder withLegends() {
        this.printLegend = true;
        return this;
    }

    public PrintStyleBuilder withoutLegends() {
        this.printLegend = false;
        return this;
    }

    public PrintStyle build() {
        if (PrintStyleBuilder.isEmpty(this.rowFormat)) {
            this.rowFormat = DEFAULT_FORMAT;
        }
        if (this.printHeader && PrintStyleBuilder.isEmpty(this.headerFormat)) {
            this.headerFormat = this.rowFormat;
        }
        if (PrintStyleBuilder.isEmpty(this.alternativeLine) && !PrintStyleBuilder.isEmpty(this.simpleLine)) {
            this.alternativeLine = this.simpleLine;
        }
        if (this.durationFormat == null) {
            this.durationFormat = DurationFormatter.DEFAULT_FORMAT;
        }
        return new PrintStyle(this);
    }

    protected PrintFormat getPrintFormat() {
        return this.printFormat;
    }

    protected DurationFormat getDurationFormat() {
        return this.durationFormat;
    }

    protected boolean isPrintLegend() {
        return this.printLegend;
    }

    protected boolean isPrintHeader() {
        return this.printHeader;
    }

    protected boolean isPrintSectionSummary() {
        return this.printSectionSummary;
    }

    protected String getHeaderFormat() {
        return this.headerFormat;
    }

    protected String getRowFormat() {
        return this.rowFormat;
    }

    protected String getSectionHeaderFormat() {
        return this.sectionHeaderFormat;
    }

    protected String getSectionSummaryRowFormat() {
        return this.sectionSummaryRowFormat;
    }

    protected String getSimpleLine() {
        return this.simpleLine;
    }

    protected String getAlternativeLine() {
        return this.alternativeLine;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static String generateLine(char character, int length) {
        if (length < 1) {
            return "";
        }
        String format = "%" + length + "s";
        return String.format(format, "").replace(' ', character);
    }
}

