/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.util.print;

import net.obvj.performetrics.util.DurationFormat;
import net.obvj.performetrics.util.print.PrintFormat;
import net.obvj.performetrics.util.print.PrintStyleBuilder;

public class PrintStyle {
    public static final PrintStyle SUMMARIZED_TABLE_NO_HEADER = PrintStyle.builder(PrintFormat.SUMMARIZED).withRowFormat("%-15s  %19s").withoutHeader().withDurationFormat(DurationFormat.FULL).withoutLegends().build();
    public static final PrintStyle SUMMARIZED_TABLE_FULL = PrintStyle.builder(SUMMARIZED_TABLE_NO_HEADER).withHeader().withSimpleLine('-', 36).withAlternativeLine('=', 36).build();
    public static final PrintStyle SUMMARIZED_CSV = PrintStyle.builder(PrintFormat.SUMMARIZED).withHeader().withRowFormat("\"%s\",\"%s\"").withDurationFormat(DurationFormat.FULL).withoutLegends().build();
    public static final PrintStyle SUMMARIZED_CSV_NO_HEADER = PrintStyle.builder(SUMMARIZED_CSV).withoutHeader().build();
    public static final PrintStyle DETAILED_TABLE_FULL = PrintStyle.builder(PrintFormat.DETAILED).withRowFormat("%5s  %19s  %19s").withHeader().withSectionHeaderFormat("%s").withSectionSummary("TOTAL %41s").withDurationFormat(DurationFormat.FULL).withoutLegends().withSimpleLine('-', 47).withAlternativeLine('=', 47).build();
    public static final PrintStyle DETAILED_CSV = PrintStyle.builder(PrintFormat.DETAILED).withRowFormat("\"%4$s\",%1$s,\"%2$s\",\"%3$s\"").withHeader("\"%4$s\",\"Session\",\"%2$s\",\"%3$s\"").withoutSectionSummary().withDurationFormat(DurationFormat.FULL).withoutLegends().build();
    public static final PrintStyle DETAILED_CSV_NO_HEADER = PrintStyle.builder(DETAILED_CSV).withoutHeader().build();
    private final PrintFormat printFormat;
    private final boolean printHeader;
    private final String headerFormat;
    private final String rowFormat;
    private final String sectionHeaderFormat;
    private final boolean printSectionSummary;
    private final String sectionSummaryRowFormat;
    private final DurationFormat durationFormat;
    private final boolean printLegend;
    private final String simpleLine;
    private final String alternativeLine;

    public static PrintStyleBuilder builder(PrintFormat printFormat) {
        return new PrintStyleBuilder(printFormat);
    }

    public static PrintStyleBuilder builder(PrintStyle source) {
        return new PrintStyleBuilder(source);
    }

    protected PrintStyle(PrintStyleBuilder builder) {
        this.printFormat = builder.getPrintFormat();
        this.printHeader = builder.isPrintHeader();
        this.headerFormat = builder.getHeaderFormat();
        this.rowFormat = builder.getRowFormat();
        this.sectionHeaderFormat = builder.getSectionHeaderFormat();
        this.printSectionSummary = builder.isPrintSectionSummary();
        this.sectionSummaryRowFormat = builder.getSectionSummaryRowFormat();
        this.durationFormat = builder.getDurationFormat();
        this.printLegend = builder.isPrintLegend();
        this.simpleLine = builder.getSimpleLine();
        this.alternativeLine = builder.getAlternativeLine();
    }

    public PrintFormat getPrintFormat() {
        return this.printFormat;
    }

    public DurationFormat getDurationFormat() {
        return this.durationFormat;
    }

    public boolean isPrintLegend() {
        return this.printLegend;
    }

    public boolean isPrintHeader() {
        return this.printHeader;
    }

    public boolean isPrintSectionSummary() {
        return this.printSectionSummary;
    }

    public String getHeaderFormat() {
        return this.headerFormat;
    }

    public String getRowFormat() {
        return this.rowFormat;
    }

    public String getSectionHeaderFormat() {
        return this.sectionHeaderFormat;
    }

    public String getSectionSummaryRowFormat() {
        return this.sectionSummaryRowFormat;
    }

    public String getSimpleLine() {
        return this.simpleLine;
    }

    public String getAlternativeLine() {
        return this.alternativeLine;
    }
}

