/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.util.print;

import java.util.List;
import java.util.Map;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.Stopwatch;
import net.obvj.performetrics.util.Duration;
import net.obvj.performetrics.util.DurationFormat;
import net.obvj.performetrics.util.print.PrintStyle;

public enum PrintFormat {
    SUMMARIZED{

        @Override
        public String format(Stopwatch stopwatch, PrintStyle style) {
            StringBuilder builder = new StringBuilder();
            1.appendLine(builder, style.getAlternativeLine());
            if (style.isPrintHeader()) {
                1.appendLine(builder, style.getHeaderFormat(), PrintFormat.HEADER_COUNTER, PrintFormat.HEADER_ELAPSED_TIME);
                1.appendLine(builder, style.getSimpleLine());
            }
            stopwatch.getTypes().forEach(type -> 1.appendLine(builder, this.toRowFormat(stopwatch, (Counter.Type)((Object)type), style)));
            1.appendLine(builder, style.getAlternativeLine());
            return builder.toString();
        }

        private String toRowFormat(Stopwatch stopwatch, Counter.Type type, PrintStyle style) {
            return String.format(style.getRowFormat(), new Object[]{type, style.getDurationFormat().format(stopwatch.elapsedTime(type), style.isPrintLegend())});
        }
    }
    ,
    DETAILED{

        @Override
        public String format(Stopwatch stopwatch, PrintStyle style) {
            StringBuilder builder = new StringBuilder();
            if (style.isPrintHeader()) {
                2.appendLine(builder, style.getAlternativeLine());
                2.appendLine(builder, style.getHeaderFormat(), PrintFormat.HEADER_SESSION, PrintFormat.HEADER_ELAPSED_TIME, PrintFormat.HEADER_ELAPSED_TIME_ACC);
            }
            Map<Counter.Type, List<Counter>> countersByType = stopwatch.getAllCountersByType();
            countersByType.forEach((type, counters) -> {
                2.appendLine(builder, style.getAlternativeLine());
                2.appendLine(builder, style.getSectionHeaderFormat(), type.toString());
                2.appendLine(builder, style.getSimpleLine());
                Duration elapsedTimeAcc = Duration.ZERO;
                for (int sequence = 0; sequence < counters.size(); ++sequence) {
                    Counter counter = (Counter)counters.get(sequence);
                    Duration elapsedTime = counter.elapsedTime();
                    elapsedTimeAcc = elapsedTimeAcc.plus(elapsedTime);
                    2.appendLine(builder, this.toRowFormat(sequence + 1, elapsedTime, elapsedTimeAcc, style));
                }
                if (style.isPrintSectionSummary()) {
                    2.appendLine(builder, style.getSimpleLine());
                    2.appendLine(builder, this.toTotalRowFormat(elapsedTimeAcc, style));
                }
            });
            2.appendLine(builder, style.getAlternativeLine());
            return builder.toString();
        }

        private String toRowFormat(int sequence, Duration elapsedTime, Duration elapsedTimeAcc, PrintStyle style) {
            DurationFormat durationFormat = style.getDurationFormat();
            boolean printLegend = style.isPrintLegend();
            return String.format(style.getRowFormat(), sequence, durationFormat.format(elapsedTime, printLegend), durationFormat.format(elapsedTimeAcc, printLegend));
        }

        private String toTotalRowFormat(Duration elapsedTimeAcc, PrintStyle style) {
            return String.format(style.getSectionSummaryRowFormat(), style.getDurationFormat().format(elapsedTimeAcc, style.isPrintLegend()));
        }
    };

    protected static final String LINE_SEPARATOR;
    private static final String HEADER_SESSION = "#";
    private static final String HEADER_COUNTER = "Counter";
    private static final String HEADER_ELAPSED_TIME = "Elapsed time";
    private static final String HEADER_ELAPSED_TIME_ACC = "Elapsed time (+)";

    public abstract String format(Stopwatch var1, PrintStyle var2);

    protected static void appendLine(StringBuilder builder, String string) {
        if (!PrintFormat.isEmpty(string)) {
            builder.append(string);
            builder.append(LINE_SEPARATOR);
        }
    }

    protected static void appendLine(StringBuilder builder, String format, Object ... args) {
        if (!PrintFormat.isEmpty(format)) {
            PrintFormat.appendLine(builder, String.format(format, args));
        }
    }

    private static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    static {
        LINE_SEPARATOR = System.getProperty("line.separator");
    }
}

