/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.util.printer;

import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.Stopwatch;
import net.obvj.performetrics.config.ConfigurationHolder;

public class PrintUtils {
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected static final String COUNTERS_TABLE_COLUMN_TIME_UNIT = "Time unit";
    protected static final String COUNTERS_TABLE_COLUMN_ELAPSED_TIME = "Elapsed time";
    protected static final String COUNTERS_TABLE_COLUMN_COUNTER = "Counter";
    protected static final String COUNTERS_TABLE_ROW_FORMAT = LINE_SEPARATOR + "| %-15s | %20s | %-12s |";
    protected static final String COUNTERS_TABLE_ROW_SEPARATOR = String.format(COUNTERS_TABLE_ROW_FORMAT, "", "", "").replace(" ", "-").replace("|", "+");
    protected static final String COUNTERS_TABLE_HEADER = String.format(COUNTERS_TABLE_ROW_FORMAT, "Counter", "Elapsed time", "Time unit");
    private static final String ELAPSED_TIME_FORMAT = "#.################";

    private PrintUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void print(Stopwatch stopwatch, PrintStream printStream) {
        PrintUtils.print(stopwatch, printStream, null);
    }

    public static void print(Stopwatch stopwatch, PrintStream printStream, TimeUnit timeUnit) {
        PrintUtils.print(PrintUtils.groupCountersByType(stopwatch), printStream, timeUnit);
    }

    protected static Map<Counter.Type, List<Counter>> groupCountersByType(Stopwatch stopwatch) {
        return PrintUtils.groupCountersByType(stopwatch.getCounters());
    }

    protected static Map<Counter.Type, List<Counter>> groupCountersByType(List<Counter> counters) {
        EnumMap<Counter.Type, List<Counter>> countersByType = new EnumMap<Counter.Type, List<Counter>>(Counter.Type.class);
        for (Counter counter : counters) {
            countersByType.compute(counter.getType(), (type, internalList) -> {
                if (internalList == null) {
                    internalList = new ArrayList<Counter>();
                }
                internalList.add(counter);
                return internalList;
            });
        }
        return countersByType;
    }

    public static void print(List<Counter> counters, PrintStream printStream) {
        printStream.print(PrintUtils.toTableFormat(PrintUtils.groupCountersByType(counters), null));
    }

    public static void print(List<Counter> counters, PrintStream printStream, TimeUnit timeUnit) {
        printStream.print(PrintUtils.toTableFormat(PrintUtils.groupCountersByType(counters), timeUnit));
    }

    public static void print(Map<Counter.Type, List<Counter>> countersByType, PrintStream printStream) {
        printStream.print(PrintUtils.toTableFormat(countersByType, null));
    }

    public static void print(Map<Counter.Type, List<Counter>> countersByType, PrintStream printStream, TimeUnit timeUnit) {
        printStream.print(PrintUtils.toTableFormat(countersByType, timeUnit));
    }

    protected static String toTableFormat(Map<Counter.Type, List<Counter>> counters) {
        return PrintUtils.toTableFormat(counters, null);
    }

    protected static String toTableFormat(Map<Counter.Type, List<Counter>> counters, TimeUnit timeUnit) {
        StringBuilder builder = new StringBuilder();
        builder.append(COUNTERS_TABLE_ROW_SEPARATOR);
        builder.append(COUNTERS_TABLE_HEADER);
        builder.append(COUNTERS_TABLE_ROW_SEPARATOR);
        for (Map.Entry<Counter.Type, List<Counter>> entries : counters.entrySet()) {
            builder.append(timeUnit == null ? PrintUtils.toTotalRowFormat(entries.getValue()) : PrintUtils.toTotalRowFormat(entries.getValue(), timeUnit));
        }
        builder.append(COUNTERS_TABLE_ROW_SEPARATOR);
        builder.append(LINE_SEPARATOR);
        return builder.toString();
    }

    protected static String toRowFormat(Counter counter) {
        return PrintUtils.toRowFormat(counter, counter.getTimeUnit());
    }

    protected static String toRowFormat(Counter counter, TimeUnit timeUnit) {
        return String.format(COUNTERS_TABLE_ROW_FORMAT, new Object[]{counter.getType(), PrintUtils.formatElapsedTime(counter, timeUnit), timeUnit.toString().toLowerCase()});
    }

    protected static String toTotalRowFormat(List<Counter> counters) {
        if (counters.isEmpty()) {
            throw new IllegalArgumentException("At least one counter is required");
        }
        return PrintUtils.toTotalRowFormat(counters, counters.get(0).getTimeUnit());
    }

    protected static String toTotalRowFormat(List<Counter> counters, TimeUnit timeUnit) {
        if (counters.isEmpty()) {
            throw new IllegalArgumentException("At least one counter is required");
        }
        String type = counters.get(0).getType().toString();
        double elapsedTime = counters.stream().map(counter -> counter.elapsedTime(timeUnit)).reduce(0.0, Double::sum);
        return String.format(COUNTERS_TABLE_ROW_FORMAT, type, PrintUtils.formatElapsedTime(elapsedTime), timeUnit.toString().toLowerCase());
    }

    protected static String formatElapsedTime(double elapsedTime) {
        DecimalFormat decimalFormat = new DecimalFormat(ELAPSED_TIME_FORMAT);
        decimalFormat.setMaximumFractionDigits(ConfigurationHolder.getConfiguration().getScale());
        return decimalFormat.format(elapsedTime);
    }

    protected static String formatElapsedTime(Counter counter, TimeUnit timeUnit) {
        return PrintUtils.formatElapsedTime(counter.elapsedTime(timeUnit));
    }
}

