/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.concurrent.TimeUnit;
import net.obvj.performetrics.config.ConfigurationHolder;

public class TimeUnitConverter {
    private TimeUnitConverter() {
        throw new IllegalStateException("Utility class");
    }

    public static double convertAndRound(long sourceDuration, TimeUnit sourceTimeUnit, TimeUnit targetTimeUnit) {
        return TimeUnitConverter.convertAndRound(sourceDuration, sourceTimeUnit, targetTimeUnit, ConfigurationHolder.getConfiguration().getScale());
    }

    public static double convertAndRound(long sourceDuration, TimeUnit sourceTimeUnit, TimeUnit targetTimeUnit, int decimalPlaces) {
        return TimeUnitConverter.round(TimeUnitConverter.convert(sourceDuration, sourceTimeUnit, targetTimeUnit), decimalPlaces);
    }

    public static double convert(long sourceDuration, TimeUnit sourceTimeUnit, TimeUnit targetTimeUnit) {
        if (sourceTimeUnit == targetTimeUnit) {
            return sourceDuration;
        }
        if (sourceTimeUnit.ordinal() < targetTimeUnit.ordinal()) {
            return (double)sourceDuration / (double)sourceTimeUnit.convert(1L, targetTimeUnit);
        }
        return targetTimeUnit.convert(sourceDuration, sourceTimeUnit);
    }

    protected static double round(double number, int decimalPlaces) {
        return BigDecimal.valueOf(number).setScale(decimalPlaces, RoundingMode.HALF_EVEN).doubleValue();
    }
}

