/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.util;

import java.util.Collection;
import java.util.Comparator;
import net.obvj.performetrics.util.Duration;

public class DurationUtils {
    private DurationUtils() {
        throw new UnsupportedOperationException("Instantiation not allowed");
    }

    public static Duration average(Collection<Duration> durations) {
        if (durations == null || durations.isEmpty()) {
            return Duration.ZERO;
        }
        Duration sum = Duration.ZERO;
        int count = 0;
        for (Duration element : durations) {
            if (element == null) continue;
            sum = sum.plus(element);
            ++count;
        }
        return count == 0 ? Duration.ZERO : sum.dividedBy(count);
    }

    public static Duration min(Collection<Duration> durations) {
        if (durations == null || durations.isEmpty()) {
            return Duration.ZERO;
        }
        return durations.stream().min(Comparator.comparingDouble(Duration::toSeconds)).orElse(Duration.ZERO);
    }

    public static Duration max(Collection<Duration> durations) {
        if (durations == null || durations.isEmpty()) {
            return Duration.ZERO;
        }
        return durations.stream().max(Comparator.comparingDouble(Duration::toSeconds)).orElse(Duration.ZERO);
    }
}

