/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.util;

import java.util.Objects;
import net.obvj.performetrics.util.Duration;
import net.obvj.performetrics.util.DurationFormat;

public class DurationFormatter {
    public static final DurationFormat DEFAULT_FORMAT = DurationFormat.SHORTER;
    protected static final String MSG_DURATION_MUST_NOT_BE_NULL = "The Duration to be formatted must not be null";
    protected static final String MSG_DURATION_FORMAT_MUST_NOT_BE_NULL = "The DurationFormat must not be null";

    private DurationFormatter() {
        throw new UnsupportedOperationException("Instantiation not allowed");
    }

    public static final String format(Duration duration) {
        return DurationFormatter.format(duration, DEFAULT_FORMAT);
    }

    public static final String format(Duration duration, DurationFormat format) {
        return DurationFormatter.format(duration, format, true);
    }

    public static final String format(Duration duration, DurationFormat format, boolean printLegend) {
        Objects.requireNonNull(duration, MSG_DURATION_MUST_NOT_BE_NULL);
        Objects.requireNonNull(format, MSG_DURATION_FORMAT_MUST_NOT_BE_NULL);
        return format.format(duration, printLegend);
    }
}

