/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.util;

import net.obvj.performetrics.util.Duration;

public enum DurationFormat {
    FULL{

        @Override
        public String format(Duration duration, boolean printLegend) {
            return String.format(DurationFormat.HOURS_FORMAT, duration.getHours(), duration.getMinutes(), duration.getSeconds(), duration.getNanoseconds()) + DurationFormat.legend(printLegend, DurationFormat.HOURS_LEGEND);
        }
    }
    ,
    SHORT{

        @Override
        public String format(Duration duration, boolean printLegend) {
            if (duration.getHours() > 0L) {
                return FULL.format(duration, printLegend);
            }
            if (duration.getMinutes() > 0) {
                return String.format(DurationFormat.MINUTES_FORMAT, duration.getMinutes(), duration.getSeconds(), duration.getNanoseconds()) + DurationFormat.legend(printLegend, DurationFormat.MINUTES_LEGEND);
            }
            return String.format(DurationFormat.SECONDS_FORMAT, duration.getSeconds(), duration.getNanoseconds()) + DurationFormat.legend(printLegend, DurationFormat.SECONDS_LEGEND);
        }
    }
    ,
    SHORTER{

        @Override
        public String format(Duration duration, boolean printLegend) {
            String format = 3.removeTrailingZeros(SHORT.format(duration, false));
            if (!printLegend) {
                return format;
            }
            if (duration.getHours() > 0L) {
                return format + DurationFormat.legend(true, DurationFormat.HOURS_LEGEND);
            }
            if (duration.getMinutes() > 0) {
                return format + DurationFormat.legend(true, DurationFormat.MINUTES_LEGEND);
            }
            return format + DurationFormat.legend(true, DurationFormat.SECONDS_LEGEND);
        }
    }
    ,
    ISO_8601{

        @Override
        public String format(Duration duration, boolean printLegend) {
            return duration.getInternalDuration().toString();
        }
    };

    private static final String HOURS_FORMAT = "%d:%02d:%02d.%09d";
    private static final String MINUTES_FORMAT = "%d:%02d.%09d";
    private static final String SECONDS_FORMAT = "%d.%09d";
    private static final String HOURS_LEGEND = "hour(s)";
    private static final String MINUTES_LEGEND = "minute(s)";
    private static final String SECONDS_LEGEND = "second(s)";

    public abstract String format(Duration var1, boolean var2);

    private static String legend(boolean printLegend, String legend) {
        return printLegend ? " " + legend : "";
    }

    static String removeTrailingZeros(String string) {
        StringBuilder builder = new StringBuilder(string);
        while (builder.charAt(builder.length() - 1) == '0') {
            builder.setLength(builder.length() - 1);
        }
        if (builder.charAt(builder.length() - 1) == '.') {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }
}

