/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.util;

import java.math.BigDecimal;
import java.time.temporal.ChronoUnit;
import java.util.EnumMap;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.obvj.performetrics.util.DurationFormat;
import net.obvj.performetrics.util.DurationFormatter;
import net.obvj.performetrics.util.TimeUnitConverter;

public class Duration {
    private static final String MSG_DURATION_TO_ADD_MUST_NOT_BE_NULL = "The Duration to add must not be null";
    public static final Duration ZERO = new Duration(java.time.Duration.ZERO);
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final EnumMap<TimeUnit, ChronoUnit> chronoUnitsByTimeUnit = new EnumMap(TimeUnit.class);
    private java.time.Duration internalDuration;

    private Duration(java.time.Duration internalDuration) {
        this.internalDuration = internalDuration;
    }

    public static Duration of(long amount, TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit, "The TimeUnit must not be null");
        ChronoUnit chronoUnit = Duration.toChronoUnit(timeUnit);
        java.time.Duration internalDuration = java.time.Duration.of(amount, chronoUnit);
        return new Duration(internalDuration);
    }

    public long getHours() {
        return this.internalDuration.getSeconds() / 3600L;
    }

    public int getMinutes() {
        return (int)(this.internalDuration.getSeconds() % 3600L / 60L);
    }

    public int getSeconds() {
        return (int)(this.internalDuration.getSeconds() % 60L);
    }

    public int getNanoseconds() {
        return this.internalDuration.getNano();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Duration)) {
            return false;
        }
        Duration other = (Duration)object;
        return this.internalDuration.equals(other.internalDuration);
    }

    public int hashCode() {
        return Objects.hash(this.internalDuration);
    }

    public String toString() {
        return DurationFormatter.format(this);
    }

    public String toString(DurationFormat format) {
        return this.toString(format, true);
    }

    public String toString(DurationFormat format, boolean printLegend) {
        return DurationFormatter.format(this, format, printLegend);
    }

    public double toTimeUnit(TimeUnit timeUnit) {
        return this.toTimeUnit(timeUnit, -1);
    }

    public double toTimeUnit(TimeUnit timeUnit, int scale) {
        BigDecimal targetSeconds = this.internalDuration.getSeconds() > 0L ? BigDecimal.valueOf(timeUnit.convert(this.internalDuration.getSeconds(), TimeUnit.SECONDS)) : BigDecimal.ZERO;
        BigDecimal targetNanoseconds = this.internalDuration.getNano() > 0 ? this.convertNanosecondsPart(timeUnit, scale) : BigDecimal.ZERO;
        return targetSeconds.add(targetNanoseconds).doubleValue();
    }

    private BigDecimal convertNanosecondsPart(TimeUnit timeUnit, int scale) {
        int nanoseconds = this.internalDuration.getNano();
        return scale >= 0 ? BigDecimal.valueOf(TimeUnitConverter.convertAndRound(nanoseconds, TimeUnit.NANOSECONDS, timeUnit, scale)) : BigDecimal.valueOf(TimeUnitConverter.convertAndRound(nanoseconds, TimeUnit.NANOSECONDS, timeUnit));
    }

    public double toSeconds() {
        return this.toTimeUnit(TimeUnit.SECONDS, 9);
    }

    public Duration plus(Duration duration) {
        Objects.requireNonNull(duration, MSG_DURATION_TO_ADD_MUST_NOT_BE_NULL);
        return new Duration(this.internalDuration.plus(duration.internalDuration));
    }

    public static Duration sum(Duration duration1, Duration duration2) {
        Objects.requireNonNull(duration1, MSG_DURATION_TO_ADD_MUST_NOT_BE_NULL);
        return duration1.plus(duration2);
    }

    public Duration dividedBy(long divisor) {
        return new Duration(this.internalDuration.dividedBy(divisor));
    }

    private static ChronoUnit toChronoUnit(TimeUnit timeUnit) {
        return chronoUnitsByTimeUnit.get((Object)timeUnit);
    }

    public java.time.Duration getInternalDuration() {
        return this.internalDuration;
    }

    static {
        chronoUnitsByTimeUnit.put(TimeUnit.NANOSECONDS, ChronoUnit.NANOS);
        chronoUnitsByTimeUnit.put(TimeUnit.MICROSECONDS, ChronoUnit.MICROS);
        chronoUnitsByTimeUnit.put(TimeUnit.MILLISECONDS, ChronoUnit.MILLIS);
        chronoUnitsByTimeUnit.put(TimeUnit.SECONDS, ChronoUnit.SECONDS);
        chronoUnitsByTimeUnit.put(TimeUnit.MINUTES, ChronoUnit.MINUTES);
        chronoUnitsByTimeUnit.put(TimeUnit.HOURS, ChronoUnit.HOURS);
        chronoUnitsByTimeUnit.put(TimeUnit.DAYS, ChronoUnit.DAYS);
    }
}

