/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.monitors;

import java.util.Objects;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.monitors.MonitoredOperation;

public class MonitoredRunnable
extends MonitoredOperation
implements Runnable {
    private Runnable targetRunnable;

    public MonitoredRunnable(Runnable targetRunnable) {
        this(targetRunnable, NO_SPECIFIC_TYPE);
    }

    public MonitoredRunnable(Runnable targetRunnable, Counter.Type ... types) {
        super(types);
        this.targetRunnable = targetRunnable;
    }

    @Override
    public void run() {
        Objects.requireNonNull(this.targetRunnable, "the target runnable must not be null");
        this.stopwatch.start();
        try {
            this.targetRunnable.run();
        }
        finally {
            this.stopwatch.stop();
        }
    }
}

