/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.monitors;

import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.obvj.performetrics.ConversionMode;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.Stopwatch;
import net.obvj.performetrics.util.Duration;
import net.obvj.performetrics.util.printer.PrintUtils;

public abstract class MonitoredOperation {
    protected static final Counter.Type[] NO_SPECIFIC_TYPE = new Counter.Type[0];
    protected Stopwatch stopwatch;

    public MonitoredOperation(Counter.Type ... types) {
        this.stopwatch = types.length > 0 ? new Stopwatch(types) : new Stopwatch();
    }

    protected List<Counter.Type> getTypes() {
        return this.stopwatch.getTypes();
    }

    public List<Counter> getCounters() {
        return this.stopwatch.getCounters();
    }

    public List<Counter> getCounters(Counter.Type type) {
        return this.stopwatch.getCounters(type);
    }

    public Duration elapsedTime(Counter.Type type) {
        return this.stopwatch.elapsedTime(type);
    }

    public double elapsedTime(Counter.Type type, TimeUnit timeUnit) {
        return this.stopwatch.elapsedTime(type, timeUnit);
    }

    public double elapsedTime(Counter.Type type, TimeUnit timeUnit, ConversionMode conversionMode) {
        return this.stopwatch.elapsedTime(type, timeUnit, conversionMode);
    }

    public void printStatistics(PrintStream printStream) {
        PrintUtils.print(this.stopwatch.getCounters(), printStream);
    }

    public void printStatistics(PrintStream printStream, TimeUnit timeUnit) {
        PrintUtils.print(this.stopwatch.getCounters(), printStream, timeUnit);
    }

    public void reset() {
        this.stopwatch.reset();
    }
}

