/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.monitors;

import java.util.Objects;
import java.util.concurrent.Callable;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.monitors.MonitoredOperation;

public class MonitoredCallable<V>
extends MonitoredOperation
implements Callable<V> {
    private Callable<V> targetCallable;

    public MonitoredCallable(Callable<V> targetCallable) {
        this(targetCallable, NO_SPECIFIC_TYPE);
    }

    public MonitoredCallable(Callable<V> targetCallable, Counter.Type ... types) {
        super(types);
        this.targetCallable = targetCallable;
    }

    @Override
    public V call() throws Exception {
        Objects.requireNonNull(this.targetCallable, "the target callable must not be null");
        this.stopwatch.start();
        try {
            V v = this.targetCallable.call();
            return v;
        }
        finally {
            this.stopwatch.stop();
        }
    }
}

