/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics;

import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.obvj.performetrics.ConversionMode;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.TimingSession;
import net.obvj.performetrics.util.Duration;
import net.obvj.performetrics.util.printer.PrintUtils;

public class Stopwatch {
    private static final String MSG_NOT_RUNNING = "The stopwatch is not running";
    private static final String MSG_TYPE_NOT_SPECIFIED = "\"{0}\" was not specified in this stopwatch. Available type(s): {1}";
    private static final Counter.Type[] DEFAULT_TYPES = Counter.Type.values();
    private final List<Counter.Type> types;
    private List<TimingSession> sessions;
    private State state;

    public Stopwatch() {
        this(DEFAULT_TYPES);
    }

    public Stopwatch(Counter.Type ... types) {
        this.types = Arrays.asList(types);
        this.reset();
    }

    public static Stopwatch createStarted() {
        return Stopwatch.createStarted(DEFAULT_TYPES);
    }

    public static Stopwatch createStarted(Counter.Type ... types) {
        Stopwatch stopwatch = new Stopwatch(types);
        stopwatch.start();
        return stopwatch;
    }

    public void reset() {
        this.sessions = new ArrayList<TimingSession>();
        this.state = State.STOPPED;
    }

    public void start() {
        this.state.start(this);
    }

    public void stop() {
        this.state.stop(this);
    }

    public boolean isStarted() {
        return this.state == State.RUNNING;
    }

    public List<Counter.Type> getTypes() {
        return this.types;
    }

    public List<Counter> getCounters() {
        return this.sessions.stream().map(TimingSession::getCounters).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Counter> getCounters(Counter.Type type) {
        return this.getCountersAsStream(type).collect(Collectors.toList());
    }

    private Stream<Counter> getCountersAsStream(Counter.Type type) {
        if (this.types.contains((Object)type)) {
            return this.sessions.stream().map(session -> session.getCounter(type));
        }
        throw new IllegalArgumentException(MessageFormat.format(MSG_TYPE_NOT_SPECIFIED, new Object[]{type, this.types}));
    }

    public Duration elapsedTime(Counter.Type type) {
        return this.getCountersAsStream(type).map(Counter::elapsedTime).reduce(Duration.ZERO, Duration::sum);
    }

    public double elapsedTime(Counter.Type type, TimeUnit timeUnit) {
        return this.getCountersAsStream(type).map(counter -> counter.elapsedTime(timeUnit)).reduce(0.0, Double::sum);
    }

    public double elapsedTime(Counter.Type type, TimeUnit timeUnit, ConversionMode conversionMode) {
        return this.getCountersAsStream(type).map(counter -> counter.elapsedTime(timeUnit, conversionMode)).reduce(0.0, Double::sum);
    }

    public void printStatistics(PrintStream printStream) {
        PrintUtils.print(this, printStream);
    }

    public void printStatistics(PrintStream printStream, TimeUnit timeUnit) {
        PrintUtils.print(this, printStream, timeUnit);
    }

    private void startNewTimingSession() {
        TimingSession session = new TimingSession(this.types.toArray(new Counter.Type[this.types.size()]));
        this.sessions.add(session);
        session.start();
        this.state = State.RUNNING;
    }

    private void stopCurrentTimingSession() {
        this.getCurrentTimingSession().ifPresent(TimingSession::stop);
        this.state = State.STOPPED;
    }

    protected Optional<TimingSession> getCurrentTimingSession() {
        return this.sessions.isEmpty() ? Optional.empty() : Optional.of(this.sessions.get(this.sessions.size() - 1));
    }

    protected List<TimingSession> getTimingSessions() {
        return this.sessions;
    }

    private static enum State {
        RUNNING{

            @Override
            void start(Stopwatch stopwatch) {
                stopwatch.stopCurrentTimingSession();
                stopwatch.startNewTimingSession();
            }

            @Override
            void stop(Stopwatch stopwatch) {
                stopwatch.stopCurrentTimingSession();
            }
        }
        ,
        STOPPED{

            @Override
            void start(Stopwatch stopwatch) {
                stopwatch.startNewTimingSession();
            }

            @Override
            void stop(Stopwatch stopwatch) {
                throw new IllegalStateException(Stopwatch.MSG_NOT_RUNNING);
            }
        };


        abstract void start(Stopwatch var1);

        abstract void stop(Stopwatch var1);
    }
}

