/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.monitors;

import java.io.PrintStream;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import net.obvj.performetrics.ConversionMode;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.Stopwatch;
import net.obvj.performetrics.util.Duration;
import net.obvj.performetrics.util.printer.PrintUtils;

abstract class MonitoredOperation {
    protected static final Counter.Type[] NO_SPECIFIC_TYPE = new Counter.Type[0];
    protected Stopwatch stopwatch;

    public MonitoredOperation(Counter.Type ... types) {
        this.stopwatch = types.length > 0 ? new Stopwatch(types) : new Stopwatch();
    }

    public Collection<Counter> getCounters() {
        return this.stopwatch.getCounters();
    }

    public Counter getCounter(Counter.Type type) {
        return this.stopwatch.getCounter(type);
    }

    public Duration elapsedTime(Counter.Type type) {
        return this.getCounter(type).elapsedTime();
    }

    public double elapsedTime(Counter.Type type, TimeUnit timeUnit) {
        return this.getCounter(type).elapsedTime(timeUnit);
    }

    public double elapsedTime(Counter.Type type, TimeUnit timeUnit, ConversionMode conversionMode) {
        return this.getCounter(type).elapsedTime(timeUnit, conversionMode);
    }

    public void printStatistics(PrintStream printStream) {
        PrintUtils.printCounters(this.stopwatch.getCounters(), printStream);
    }

    public void printStatistics(PrintStream printStream, TimeUnit timeUnit) {
        PrintUtils.printCounters(this.stopwatch.getCounters(), printStream, timeUnit);
    }
}

