/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics;

import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.obvj.performetrics.ConversionMode;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.util.Duration;
import net.obvj.performetrics.util.printer.PrintUtils;

public class Stopwatch {
    private static final String MSG_STOPWATCH_ALREADY_STARTED = "The stopwatch is already started";
    private static final String MSG_STOPWATCH_MUST_BE_RESET = "The stopwatch must be reset before being restarted";
    private static final String MSG_STOPWATCH_NOT_RUNNING = "The stopwatch is not running";
    private static final String MSG_TYPE_NOT_AVAILABLE = "\"{0}\" is not available in this stopwatch. Available type(s): {1}";
    private static final Counter.Type[] DEFAULT_TYPES = Counter.Type.values();
    private final Counter.Type[] types;
    private Map<Counter.Type, Counter> counters;
    private State state = State.READY;

    public Stopwatch() {
        this(DEFAULT_TYPES);
    }

    public Stopwatch(Counter.Type ... types) {
        this.types = types;
        this.reset();
    }

    public static Stopwatch createStarted() {
        return Stopwatch.createStarted(DEFAULT_TYPES);
    }

    public static Stopwatch createStarted(Counter.Type ... types) {
        Stopwatch stopwatch = new Stopwatch(types);
        stopwatch.start();
        return stopwatch;
    }

    public void reset() {
        this.counters = new EnumMap<Counter.Type, Counter>(Counter.Type.class);
        for (Counter.Type type : this.types) {
            this.counters.put(type, new Counter(type));
        }
        this.state = State.READY;
    }

    public void start() {
        this.state.start(this);
    }

    public void stop() {
        this.state.stop(this);
    }

    public boolean isStarted() {
        return this.state == State.RUNNING;
    }

    public Collection<Counter> getCounters() {
        return this.counters.values();
    }

    public Counter getCounter(Counter.Type type) {
        if (!this.counters.containsKey((Object)type)) {
            throw new IllegalArgumentException(MessageFormat.format(MSG_TYPE_NOT_AVAILABLE, new Object[]{type, this.counters.keySet()}));
        }
        return this.counters.get((Object)type);
    }

    public Duration elapsedTime(Counter.Type type) {
        return this.getCounter(type).elapsedTime();
    }

    public double elapsedTime(Counter.Type type, TimeUnit timeUnit) {
        return this.getCounter(type).elapsedTime(timeUnit);
    }

    public double elapsedTime(Counter.Type type, TimeUnit timeUnit, ConversionMode conversionMode) {
        return this.getCounter(type).elapsedTime(timeUnit, conversionMode);
    }

    public void printStatistics(PrintStream printStream) {
        PrintUtils.printStopwatch(this, printStream);
    }

    public void printStatistics(PrintStream printStream, TimeUnit timeUnit) {
        PrintUtils.printStopwatch(this, printStream, timeUnit);
    }

    private void doStart() {
        for (Counter counter : this.counters.values()) {
            counter.setUnitsBefore();
        }
        this.state = State.RUNNING;
    }

    private void doStop() {
        for (Counter counter : this.counters.values()) {
            counter.setUnitsAfter();
        }
        this.state = State.STOPPED;
    }

    private static enum State {
        READY{

            @Override
            void start(Stopwatch stopwatch) {
                stopwatch.doStart();
            }

            @Override
            void stop(Stopwatch stopwatch) {
                throw new IllegalStateException(Stopwatch.MSG_STOPWATCH_NOT_RUNNING);
            }
        }
        ,
        RUNNING{

            @Override
            void start(Stopwatch stopwatch) {
                throw new IllegalStateException(Stopwatch.MSG_STOPWATCH_ALREADY_STARTED);
            }

            @Override
            void stop(Stopwatch stopwatch) {
                stopwatch.doStop();
            }
        }
        ,
        STOPPED{

            @Override
            void start(Stopwatch stopwatch) {
                throw new IllegalStateException(Stopwatch.MSG_STOPWATCH_MUST_BE_RESET);
            }

            @Override
            void stop(Stopwatch stopwatch) {
                throw new IllegalStateException(Stopwatch.MSG_STOPWATCH_NOT_RUNNING);
            }
        };


        abstract void start(Stopwatch var1);

        abstract void stop(Stopwatch var1);
    }
}

