/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.util.printer;

import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.Stopwatch;

public class PrintUtils {
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected static final String COUNTERS_TABLE_COLUMN_TIME_UNIT = "Time unit";
    protected static final String COUNTERS_TABLE_COLUMN_ELAPSED_TIME = "Elapsed time";
    protected static final String COUNTERS_TABLE_COLUMN_COUNTER = "Counter";
    protected static final String COUNTERS_TABLE_ROW_FORMAT = LINE_SEPARATOR + "| %-15s | %20s | %-12s |";
    protected static final String COUNTERS_TABLE_ROW_SEPARATOR = String.format(COUNTERS_TABLE_ROW_FORMAT, "", "", "").replace(" ", "-").replace("|", "+");
    protected static final String COUNTERS_TABLE_HEADER = String.format(COUNTERS_TABLE_ROW_FORMAT, "Counter", "Elapsed time", "Time unit");
    private static final String ELAPSED_TIME_FORMAT = "#.################";

    private PrintUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void printStopwatch(Stopwatch stopwatch, PrintStream printStream) {
        PrintUtils.printStopwatch(stopwatch, printStream, null);
    }

    public static void printCounters(Collection<Counter> counters, PrintStream printStream) {
        PrintUtils.printCounters(counters, printStream, null);
    }

    public static void printStopwatch(Stopwatch stopwatch, PrintStream printStream, TimeUnit timeUnit) {
        PrintUtils.printCounters(stopwatch.getCounters(), printStream, timeUnit);
    }

    public static void printCounters(Collection<Counter> counters, PrintStream printStream, TimeUnit timeUnit) {
        printStream.print(PrintUtils.toTableFormat(counters, timeUnit));
    }

    protected static String toTableFormat(Collection<Counter> counters) {
        return PrintUtils.toTableFormat(counters, null);
    }

    protected static String toTableFormat(Collection<Counter> counters, TimeUnit timeUnit) {
        StringBuilder builder = new StringBuilder();
        builder.append(COUNTERS_TABLE_ROW_SEPARATOR);
        builder.append(COUNTERS_TABLE_HEADER);
        builder.append(COUNTERS_TABLE_ROW_SEPARATOR);
        for (Counter counter : counters) {
            builder.append(timeUnit == null ? PrintUtils.toRowFormat(counter) : PrintUtils.toRowFormat(counter, timeUnit));
        }
        builder.append(COUNTERS_TABLE_ROW_SEPARATOR);
        builder.append(LINE_SEPARATOR);
        return builder.toString();
    }

    protected static String toRowFormat(Counter counter) {
        return PrintUtils.toRowFormat(counter, counter.getTimeUnit());
    }

    protected static String toRowFormat(Counter counter, TimeUnit timeUnit) {
        return String.format(COUNTERS_TABLE_ROW_FORMAT, new Object[]{counter.getType(), PrintUtils.formatElapsedTime(counter, timeUnit), timeUnit.toString().toLowerCase()});
    }

    protected static String formatElapsedTime(Counter counter, TimeUnit timeUnit) {
        return new DecimalFormat(ELAPSED_TIME_FORMAT).format(counter.elapsedTime(timeUnit));
    }
}

