/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.util;

import java.time.temporal.ChronoUnit;
import java.util.EnumMap;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class Duration {
    public static final Duration ZERO = new Duration(0L, 0, 0, 0);
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final FormatStyle DEFAULT_FORMAT_STYLE = FormatStyle.SHORTER;
    private static final EnumMap<TimeUnit, ChronoUnit> chronoUnitsByTimeUnit = new EnumMap(TimeUnit.class);
    private final long hours;
    private final int minutes;
    private final int seconds;
    private final int nanoseconds;

    private Duration(long hours, int minutes, int seconds, int nanoseconds) {
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        this.nanoseconds = nanoseconds;
    }

    public static Duration of(long amount, TimeUnit timeUnit) {
        if (amount < 0L) {
            throw new IllegalArgumentException("The amount must be a positive integer");
        }
        java.time.Duration duration = java.time.Duration.of(amount, Duration.toChronoUnit(timeUnit));
        long effectiveTotalSeconds = duration.getSeconds();
        long hours = effectiveTotalSeconds / 3600L;
        int minutes = (int)(effectiveTotalSeconds % 3600L / 60L);
        int seconds = (int)(effectiveTotalSeconds % 60L);
        return new Duration(hours, minutes, seconds, duration.getNano());
    }

    public long getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getNanoseconds() {
        return this.nanoseconds;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Duration)) {
            return false;
        }
        Duration other = (Duration)object;
        return this.hours == other.hours && this.minutes == other.minutes && this.nanoseconds == other.nanoseconds && this.seconds == other.seconds;
    }

    public int hashCode() {
        return Objects.hash(this.hours, this.minutes, this.nanoseconds, this.seconds);
    }

    public String toString() {
        return this.toString(DEFAULT_FORMAT_STYLE);
    }

    public String toString(FormatStyle style) {
        return this.toString(style, true);
    }

    public String toString(FormatStyle style, boolean printLegend) {
        return style.format(this, printLegend);
    }

    private static ChronoUnit toChronoUnit(TimeUnit timeUnit) {
        return chronoUnitsByTimeUnit.get((Object)timeUnit);
    }

    static {
        chronoUnitsByTimeUnit.put(TimeUnit.NANOSECONDS, ChronoUnit.NANOS);
        chronoUnitsByTimeUnit.put(TimeUnit.MICROSECONDS, ChronoUnit.MICROS);
        chronoUnitsByTimeUnit.put(TimeUnit.MILLISECONDS, ChronoUnit.MILLIS);
        chronoUnitsByTimeUnit.put(TimeUnit.SECONDS, ChronoUnit.SECONDS);
        chronoUnitsByTimeUnit.put(TimeUnit.MINUTES, ChronoUnit.MINUTES);
        chronoUnitsByTimeUnit.put(TimeUnit.HOURS, ChronoUnit.HOURS);
        chronoUnitsByTimeUnit.put(TimeUnit.DAYS, ChronoUnit.DAYS);
    }

    public static enum FormatStyle {
        FULL{

            @Override
            public String format(Duration duration, boolean printLegend) {
                return String.format(FormatStyle.HOURS_FORMAT, duration.hours, duration.minutes, duration.seconds, duration.nanoseconds) + 1.legend(printLegend, FormatStyle.HOURS_LEGEND);
            }
        }
        ,
        SHORT{

            @Override
            public String format(Duration duration, boolean printLegend) {
                if (duration.hours > 0L) {
                    return FULL.format(duration, printLegend);
                }
                if (duration.minutes > 0) {
                    return String.format(FormatStyle.MINUTES_FORMAT, duration.minutes, duration.seconds, duration.nanoseconds) + 2.legend(printLegend, FormatStyle.MINUTES_LEGEND);
                }
                return String.format(FormatStyle.SECONDS_FORMAT, duration.seconds, duration.nanoseconds) + 2.legend(printLegend, FormatStyle.SECONDS_LEGEND);
            }
        }
        ,
        SHORTER{

            @Override
            public String format(Duration duration, boolean printLegend) {
                String format = 3.removeTrailingZeros(SHORT.format(duration, false));
                if (!printLegend) {
                    return format;
                }
                if (duration.hours > 0L) {
                    return format + 3.legend(true, FormatStyle.HOURS_LEGEND);
                }
                if (duration.minutes > 0) {
                    return format + 3.legend(true, FormatStyle.MINUTES_LEGEND);
                }
                return format + 3.legend(true, FormatStyle.SECONDS_LEGEND);
            }
        }
        ,
        ISO_8601{

            @Override
            public String format(Duration duration, boolean printLegend) {
                if (ZERO.equals(duration)) {
                    return "PT0S";
                }
                StringBuilder builder = new StringBuilder();
                builder.append("PT");
                if (duration.hours > 0L) {
                    builder.append(duration.hours).append('H');
                }
                if (duration.minutes > 0) {
                    builder.append(duration.minutes).append('M');
                }
                if (duration.seconds > 0 || duration.nanoseconds > 0) {
                    builder.append(duration.seconds);
                    if (duration.nanoseconds > 0) {
                        String nanos = 4.removeTrailingZeros(String.format(FormatStyle.NANOSECONDS_FORMAT, duration.nanoseconds));
                        builder.append(".").append(nanos);
                    }
                    builder.append('S');
                }
                return builder.toString();
            }
        };

        private static final String HOURS_FORMAT = "%d:%02d:%02d.%09d";
        private static final String MINUTES_FORMAT = "%d:%02d.%09d";
        private static final String SECONDS_FORMAT = "%d.%09d";
        private static final String NANOSECONDS_FORMAT = "%09d";
        private static final String HOURS_LEGEND = "hour(s)";
        private static final String MINUTES_LEGEND = "minute(s)";
        private static final String SECONDS_LEGEND = "second(s)";

        public abstract String format(Duration var1, boolean var2);

        static String legend(boolean printLegendFlag, String legend) {
            return printLegendFlag ? " " + legend : "";
        }

        static String removeTrailingZeros(String string) {
            StringBuilder builder = new StringBuilder(string);
            while (builder.charAt(builder.length() - 1) == '0') {
                builder.setLength(builder.length() - 1);
            }
            if (builder.charAt(builder.length() - 1) == '.') {
                builder.setLength(builder.length() - 1);
            }
            return builder.toString();
        }
    }
}

