/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.runnable;

import java.util.concurrent.TimeUnit;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.SimpleMonitorableOperation;
import net.obvj.performetrics.util.PerformetricsUtils;

public class WallClockTimeRunnableOperation
extends SimpleMonitorableOperation
implements Runnable {
    private Runnable targetRunnable;

    public WallClockTimeRunnableOperation(Runnable targetRunnable) {
        super(Counter.Type.WALL_CLOCK_TIME, TimeUnit.MILLISECONDS);
        this.targetRunnable = targetRunnable;
    }

    @Override
    public void run() {
        this.counter.setUnitsAfter(0L);
        this.counter.setUnitsBefore(PerformetricsUtils.getWallClockTimeMillis());
        try {
            this.targetRunnable.run();
        }
        finally {
            this.counter.setUnitsAfter(PerformetricsUtils.getWallClockTimeMillis());
        }
    }
}

