/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.callable;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.SimpleMonitorableOperation;
import net.obvj.performetrics.util.PerformetricsUtils;

public class WallClockTimeCallableOperation<V>
extends SimpleMonitorableOperation
implements Callable<V> {
    private Callable<V> targetCallable;
    private Object lock = new Object();

    public WallClockTimeCallableOperation(Callable<V> targetCallable) {
        super(Counter.Type.WALL_CLOCK_TIME, TimeUnit.MILLISECONDS);
        this.targetCallable = targetCallable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public V call() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.counter.setUnitsAfter(0L);
            this.counter.setUnitsBefore(PerformetricsUtils.getWallClockTimeMillis());
            V v = this.targetCallable.call();
            return v;
            finally {
                this.counter.setUnitsAfter(PerformetricsUtils.getWallClockTimeMillis());
            }
        }
    }
}

