/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics.callable;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.SimpleMonitorableOperation;
import net.obvj.performetrics.util.PerformetricsUtils;

public class CpuTimeCallableOperation<V>
extends SimpleMonitorableOperation
implements Callable<V> {
    private Callable<V> targetCallable;

    public CpuTimeCallableOperation(Callable<V> targetCallable) {
        super(Counter.Type.CPU_TIME, TimeUnit.NANOSECONDS);
        this.targetCallable = targetCallable;
    }

    @Override
    public V call() throws Exception {
        this.counter.setUnitsAfter(0L);
        this.counter.setUnitsBefore(PerformetricsUtils.getCpuTimeNanos());
        try {
            V v = this.targetCallable.call();
            return v;
        }
        finally {
            this.counter.setUnitsAfter(PerformetricsUtils.getCpuTimeNanos());
        }
    }
}

