/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics;

import java.io.PrintStream;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.obvj.performetrics.Counter;
import net.obvj.performetrics.util.printer.PrintUtils;

public class Stopwatch {
    private static final Counter.Type[] DEFAULT_TYPES = Counter.Type.values();
    private final Counter.Type[] types;
    private Map<Counter.Type, Counter> counters;

    public Stopwatch() {
        this(DEFAULT_TYPES);
    }

    public Stopwatch(Counter.Type ... types) {
        this.types = types;
        this.reset();
    }

    public static Stopwatch createStarted() {
        return Stopwatch.createStarted(DEFAULT_TYPES);
    }

    public static Stopwatch createStarted(Counter.Type ... types) {
        Stopwatch stopwatch = new Stopwatch(types);
        stopwatch.start();
        return stopwatch;
    }

    public void reset() {
        this.counters = new EnumMap<Counter.Type, Counter>(Counter.Type.class);
        for (Counter.Type type : this.types) {
            this.counters.put(type, new Counter(type));
        }
    }

    public void start() {
        for (Counter counter : this.counters.values()) {
            counter.before();
        }
    }

    public void stop() {
        for (Counter counter : this.counters.values()) {
            counter.after();
        }
    }

    public Collection<Counter> getAllCounters() {
        return this.counters.values();
    }

    public Counter getCounter(Counter.Type type) {
        return this.counters.get((Object)type);
    }

    public void printStatistics(PrintStream printStream) {
        PrintUtils.printStopwatch(this, printStream);
    }

    public void printStatistics(PrintStream printStream, TimeUnit timeUnit) {
        PrintUtils.printStopwatch(this, printStream, timeUnit);
    }
}

