/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.performetrics;

import java.util.concurrent.TimeUnit;
import net.obvj.performetrics.util.PerformetricsUtils;

public class Counter {
    protected static final String STRING_FORMAT = "Counter [type=%s, timeUnit=%s, unitsBefore=%s, unitsAfter=%s]";
    public static final TimeUnit DEFAULT_UNIT = TimeUnit.NANOSECONDS;
    private final Type type;
    private final TimeUnit defaultTimeUnit;
    private long unitsBefore = 0L;
    private long unitsAfter = 0L;
    private boolean unitsAfterFlag = false;

    public Counter(Type type) {
        this(type, DEFAULT_UNIT);
    }

    public Counter(Type type, TimeUnit timeUnit) {
        this.type = type;
        this.defaultTimeUnit = timeUnit;
    }

    public long getUnitsBefore() {
        return this.unitsBefore;
    }

    public void setUnitsBefore(long unitsBefore) {
        this.unitsBefore = unitsBefore;
    }

    public long getUnitsAfter() {
        return this.unitsAfter;
    }

    public void setUnitsAfter(long unitsAfter) {
        this.unitsAfter = unitsAfter;
        this.unitsAfterFlag = true;
    }

    public Type getType() {
        return this.type;
    }

    public TimeUnit getDefaultTimeUnit() {
        return this.defaultTimeUnit;
    }

    public void before() {
        this.unitsBefore = this.type.defaultDataFetchStrategy(this.defaultTimeUnit);
    }

    public void after() {
        this.setUnitsAfter(this.type.defaultDataFetchStrategy(this.defaultTimeUnit));
    }

    private static long elapsedTime(long unitsBefore, long unitsAfter) {
        return unitsAfter >= unitsBefore ? unitsAfter - unitsBefore : -1L;
    }

    public long elapsedTime() {
        long tempUnitsAfter = this.unitsAfterFlag ? this.unitsAfter : this.type.defaultDataFetchStrategy(this.defaultTimeUnit);
        return Counter.elapsedTime(this.unitsBefore, tempUnitsAfter);
    }

    public long elapsedTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.elapsedTime(), this.defaultTimeUnit);
    }

    public String toString() {
        return String.format(STRING_FORMAT, new Object[]{this.type, this.defaultTimeUnit, this.unitsBefore, this.unitsAfter});
    }

    public static enum Type {
        WALL_CLOCK_TIME("Wall clock time"){

            @Override
            public long defaultDataFetchStrategy(TimeUnit targetTimeUnit) {
                return targetTimeUnit.convert(PerformetricsUtils.getWallClockTimeNanos(), TimeUnit.NANOSECONDS);
            }
        }
        ,
        CPU_TIME("CPU time"){

            @Override
            public long defaultDataFetchStrategy(TimeUnit targetTimeUnit) {
                return targetTimeUnit.convert(PerformetricsUtils.getCpuTimeNanos(), TimeUnit.NANOSECONDS);
            }
        }
        ,
        USER_TIME("User time"){

            @Override
            public long defaultDataFetchStrategy(TimeUnit targetTimeUnit) {
                return targetTimeUnit.convert(PerformetricsUtils.getUserTimeNanos(), TimeUnit.NANOSECONDS);
            }
        }
        ,
        SYSTEM_TIME("System time"){

            @Override
            public long defaultDataFetchStrategy(TimeUnit targetTimeUnit) {
                return targetTimeUnit.convert(PerformetricsUtils.getSystemTimeNanos(), TimeUnit.NANOSECONDS);
            }
        };

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public abstract long defaultDataFetchStrategy(TimeUnit var1);
    }
}

