/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.junit.utils.matchers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.obvj.junit.utils.Procedure;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class ExceptionMatcher
extends TypeSafeDiagnosingMatcher<Procedure> {
    private static final String INDENT = "          ";
    private static final String NEW_LINE_INDENT = "\n          ";
    private final Class<? extends Exception> expectedException;
    private CauseMatchingStrategy causeMatchingStrategy;
    private Class<? extends Throwable> expectedCause;
    private ExceptionMatcher causeMatcher;
    private boolean checkCauseFlag = false;
    private boolean checkMessageFlag = false;
    private MessageMatchingStrategy messageMatchingStrategy;
    private List<String> expectedMessageSubstrings = Collections.emptyList();
    private Matcher<String> messageMatcher;
    private List<CustomFunction> customFunctions;

    private ExceptionMatcher(Class<? extends Exception> expectedException) {
        this.expectedException = expectedException;
    }

    public static ExceptionMatcher throwsException() {
        return new ExceptionMatcher(Exception.class);
    }

    public static ExceptionMatcher throwsException(Class<? extends Exception> exception) {
        return new ExceptionMatcher(exception);
    }

    public static ExceptionMatcher exception(Class<? extends Exception> exception) {
        return new ExceptionMatcher(exception);
    }

    public static Matcher<Procedure> throwsNoException() {
        return new ExceptionMatcher(null);
    }

    public ExceptionMatcher withCause(Class<? extends Throwable> cause) {
        this.expectedCause = cause;
        this.checkCauseFlag = true;
        this.causeMatchingStrategy = CauseMatchingStrategy.EXPECTED_CLASS;
        return this;
    }

    public ExceptionMatcher withCause(ExceptionMatcher matcher) {
        this.causeMatcher = matcher;
        this.checkCauseFlag = true;
        this.causeMatchingStrategy = CauseMatchingStrategy.NESTED_MATCHER;
        return this;
    }

    public ExceptionMatcher withNoCause() {
        return this.withCause((Class<? extends Throwable>)null);
    }

    public ExceptionMatcher withMessage(Matcher<String> matcher) {
        this.messageMatcher = matcher;
        this.checkMessageFlag = true;
        this.messageMatchingStrategy = MessageMatchingStrategy.EXTERNAL_MATCHER;
        return this;
    }

    public ExceptionMatcher withMessage(String message) {
        return this.withMessage((Matcher<String>)CoreMatchers.equalTo((Object)message));
    }

    public ExceptionMatcher withMessageContaining(String ... substrings) {
        if (substrings != null) {
            this.expectedMessageSubstrings = Arrays.asList(substrings);
        }
        this.checkMessageFlag = true;
        this.messageMatchingStrategy = MessageMatchingStrategy.EXPECTED_SUBSTRINGS;
        return this;
    }

    public <T> ExceptionMatcher with(Function<? super T, Object> function, Matcher<?> matcher) {
        if (this.customFunctions == null) {
            this.customFunctions = new ArrayList<CustomFunction>();
        }
        this.customFunctions.add(new CustomFunction(function, matcher));
        return this;
    }

    protected boolean matchesSafely(Procedure procedure, Description mismatch) {
        try {
            procedure.execute();
            mismatch.appendText(NEW_LINE_INDENT).appendText("no exception was thrown");
            return this.expectedException == null;
        }
        catch (Throwable exception) {
            return this.validateFully(exception, mismatch);
        }
    }

    protected boolean validateFully(Throwable throwable, Description mismatch) {
        if (!this.validateException(throwable, mismatch)) {
            return false;
        }
        if (this.checkMessageFlag && !this.validateMessage(throwable, mismatch)) {
            return false;
        }
        if (this.checkCauseFlag && !this.validateCause(throwable, mismatch)) {
            return false;
        }
        return this.validateCustomFunctions(throwable, mismatch);
    }

    private boolean validateException(Throwable throwable, Description mismatch) {
        if (this.expectedException == null || !this.expectedException.isAssignableFrom(throwable.getClass())) {
            mismatch.appendText(NEW_LINE_INDENT).appendText("was ").appendText(ExceptionMatcher.nullSafeClassNameToText(throwable.getClass()));
            return false;
        }
        return true;
    }

    private boolean validateMessage(Throwable throwable, Description mismatch) {
        return this.messageMatchingStrategy.validateMessage(this, throwable, mismatch);
    }

    private boolean validateCause(Throwable throwable, Description mismatch) {
        return this.causeMatchingStrategy.validateCause(this, throwable, mismatch);
    }

    private boolean validateCustomFunctions(Throwable throwable, Description mismatch) {
        if (this.customFunctions != null) {
            for (int i = 0; i < this.customFunctions.size(); ++i) {
                CustomFunction custom = this.customFunctions.get(i);
                Object actual = custom.function.apply(throwable);
                if (custom.matcher.matches(actual)) continue;
                mismatch.appendText(NEW_LINE_INDENT).appendText("the value retrieved by the function #" + (i + 1) + " ");
                custom.matcher.describeMismatch(actual, mismatch);
                return false;
            }
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText(NEW_LINE_INDENT).appendText(ExceptionMatcher.nullSafeClassNameToText(this.expectedException));
        if (this.checkMessageFlag) {
            this.messageMatchingStrategy.describeTo(this, description);
        }
        if (this.checkCauseFlag) {
            this.causeMatchingStrategy.describeTo(this, description);
        }
        if (this.customFunctions != null) {
            IntStream.range(0, this.customFunctions.size()).forEach(i -> {
                description.appendText(NEW_LINE_INDENT).appendText("and the function #" + (i + 1) + ": ");
                this.customFunctions.get(i).matcher.describeTo(description);
            });
        }
    }

    private static String nullSafeClassNameToText(Class<?> clazz) {
        return clazz != null ? clazz.getCanonicalName() : "no exception";
    }

    protected Class<? extends Exception> getExpectedException() {
        return this.expectedException;
    }

    private static class CustomFunction {
        private final Function<? super Throwable, Object> function;
        private final Matcher<?> matcher;

        private CustomFunction(Function<? super Throwable, Object> function, Matcher<?> matcher) {
            this.function = function;
            this.matcher = matcher;
        }
    }

    private static enum CauseMatchingStrategy {
        EXPECTED_CLASS{

            @Override
            boolean validateCause(ExceptionMatcher parent, Throwable throwable, Description mismatch) {
                Throwable cause = throwable.getCause();
                if (cause == null && parent.expectedCause != null) {
                    mismatch.appendText(ExceptionMatcher.NEW_LINE_INDENT).appendText("the cause was null");
                    return false;
                }
                if (!(cause == null || parent.expectedCause != null && parent.expectedCause.isAssignableFrom(cause.getClass()))) {
                    mismatch.appendText(ExceptionMatcher.NEW_LINE_INDENT).appendText("the cause was: ").appendText(ExceptionMatcher.nullSafeClassNameToText(cause.getClass()));
                    return false;
                }
                return true;
            }

            @Override
            void describeTo(ExceptionMatcher parent, Description description) {
                description.appendText(ExceptionMatcher.NEW_LINE_INDENT).appendText("and cause: ").appendText(ExceptionMatcher.nullSafeClassNameToText(parent.expectedCause));
            }
        }
        ,
        NESTED_MATCHER{

            @Override
            boolean validateCause(ExceptionMatcher parent, final Throwable throwable, Description mismatch) {
                Procedure causeThrowingProcedure = new Procedure(){

                    @Override
                    public void execute() throws Throwable {
                        throw throwable.getCause();
                    }
                };
                boolean matcherResult = parent.causeMatcher.matches(causeThrowingProcedure);
                if (!matcherResult) {
                    mismatch.appendText(ExceptionMatcher.NEW_LINE_INDENT).appendText("the cause did not match: {");
                    parent.causeMatcher.describeMismatch(causeThrowingProcedure, mismatch);
                    mismatch.appendText(ExceptionMatcher.NEW_LINE_INDENT).appendText("}");
                }
                return matcherResult;
            }

            @Override
            void describeTo(ExceptionMatcher parent, Description description) {
                description.appendText(ExceptionMatcher.NEW_LINE_INDENT).appendText("and cause: {");
                parent.causeMatcher.describeTo(description);
                description.appendText(ExceptionMatcher.NEW_LINE_INDENT).appendText("}");
            }
        };


        abstract boolean validateCause(ExceptionMatcher var1, Throwable var2, Description var3);

        abstract void describeTo(ExceptionMatcher var1, Description var2);
    }

    private static enum MessageMatchingStrategy {
        EXPECTED_SUBSTRINGS{

            @Override
            boolean validateMessage(ExceptionMatcher parent, Throwable throwable, Description mismatch) {
                String message = throwable.getMessage();
                if (message == null) {
                    if (parent.expectedMessageSubstrings.isEmpty()) {
                        return true;
                    }
                    mismatch.appendText(ExceptionMatcher.NEW_LINE_INDENT).appendText("the message was null");
                    return false;
                }
                for (String substring : parent.expectedMessageSubstrings) {
                    if (message.contains(substring)) continue;
                    mismatch.appendText(ExceptionMatcher.NEW_LINE_INDENT).appendText("the message was ").appendValue((Object)message);
                    return false;
                }
                return true;
            }

            @Override
            void describeTo(ExceptionMatcher parent, Description description) {
                description.appendText(ExceptionMatcher.NEW_LINE_INDENT).appendText("with message containing: ").appendText(parent.expectedMessageSubstrings.toString());
            }
        }
        ,
        EXTERNAL_MATCHER{

            @Override
            boolean validateMessage(ExceptionMatcher parent, Throwable throwable, Description mismatch) {
                String message = throwable.getMessage();
                if (message == null && parent.messageMatcher == null) {
                    return true;
                }
                if (parent.messageMatcher == null) {
                    mismatch.appendText(ExceptionMatcher.NEW_LINE_INDENT).appendText("the message was ").appendValue((Object)message);
                    return false;
                }
                boolean matcherResult = parent.messageMatcher.matches((Object)message);
                if (!matcherResult) {
                    mismatch.appendText(ExceptionMatcher.NEW_LINE_INDENT).appendText("the message ");
                    parent.messageMatcher.describeMismatch((Object)message, mismatch);
                }
                return matcherResult;
            }

            @Override
            void describeTo(ExceptionMatcher parent, Description description) {
                description.appendText(ExceptionMatcher.NEW_LINE_INDENT).appendText("with message: ");
                if (parent.messageMatcher != null) {
                    parent.messageMatcher.describeTo(description);
                } else {
                    description.appendText("<null>");
                }
            }
        };


        abstract boolean validateMessage(ExceptionMatcher var1, Throwable var2, Description var3);

        abstract void describeTo(ExceptionMatcher var1, Description var2);
    }
}

