/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.junit.utils.matchers;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Objects;
import net.obvj.junit.utils.matchers.ExceptionMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class InstantiationNotAllowedMatcher
extends TypeSafeDiagnosingMatcher<Class<?>> {
    private ExceptionMatcher exceptionMatcher;

    public static InstantiationNotAllowedMatcher instantiationNotAllowed() {
        return new InstantiationNotAllowedMatcher();
    }

    public InstantiationNotAllowedMatcher throwing(Class<? extends Exception> exception) {
        Objects.requireNonNull(exception, "the expected exception must not be null");
        this.exceptionMatcher = ExceptionMatcher.throwsException(exception);
        return this;
    }

    public InstantiationNotAllowedMatcher withMessage(String message) {
        return this.withMessage((Matcher<String>)CoreMatchers.equalTo((Object)message));
    }

    public InstantiationNotAllowedMatcher withMessage(Matcher<String> matcher) {
        if (this.exceptionMatcher == null) {
            this.exceptionMatcher = ExceptionMatcher.throwsException(Exception.class);
        }
        this.exceptionMatcher.withMessage(matcher);
        return this;
    }

    protected boolean matchesSafely(Class<?> clazz, Description mismatch) {
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (Modifier.isPrivate(constructor.getModifiers())) continue;
            mismatch.appendText("the constructor \"" + constructor + "\" is not private");
            return false;
        }
        return this.checkInstantiationNotAllowed(clazz, mismatch);
    }

    private boolean checkInstantiationNotAllowed(Class<?> clazz, Description mismatch) {
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            constructor.newInstance(new Object[0]);
            mismatch.appendText("instantiation via Reflection was allowed by the constructor \"" + constructor + "\"");
            return false;
        }
        catch (ReflectiveOperationException exception) {
            if (this.exceptionMatcher != null) {
                return this.exceptionMatcher.validateFully(exception.getCause(), mismatch);
            }
            return true;
        }
    }

    public void describeTo(Description description) {
        description.appendText("a class which cannot be instantiated");
        if (this.exceptionMatcher != null) {
            description.appendText(", throwing");
            this.exceptionMatcher.describeTo(description);
        }
    }
}

