/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.junit.utils.matchers;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class StringMatcher
extends TypeSafeDiagnosingMatcher<String> {
    private static final String EXPECTED_SCENARIO = "a string containing %s of the specified substrings %s";
    private static final String EXPECTED_STRING_NOT_FOUND = "the substring \"%s\" was not found in: \"%s\"";
    private static final String NONE_OF_THE_STRINGS_FOUND = "none of the specified substrings was found in: \"%s\"";
    private static final String UNEXPECTED_STRING_FOUND = "the unexpected string \"%s\" was found in: \"%s\"";
    private final Strategy strategy;
    private final List<String> substrings;
    private CaseStrategy caseStrategy;

    private StringMatcher(Strategy strategy, CaseStrategy caseStrategy, String ... substrings) {
        this.strategy = strategy;
        this.caseStrategy = caseStrategy;
        this.substrings = Arrays.asList(substrings);
    }

    @Factory
    public static StringMatcher containsAll(String ... substrings) {
        return new StringMatcher(Strategy.ALL, CaseStrategy.DEFAULT, substrings);
    }

    @Factory
    public static StringMatcher containsAny(String ... substrings) {
        return new StringMatcher(Strategy.ANY, CaseStrategy.DEFAULT, substrings);
    }

    @Factory
    public static StringMatcher containsNone(String ... substrings) {
        return new StringMatcher(Strategy.NONE, CaseStrategy.DEFAULT, substrings);
    }

    public StringMatcher ignoreCase() {
        this.caseStrategy = CaseStrategy.IGNORE_CASE;
        return this;
    }

    protected boolean matchesSafely(String string, Description mismatch) {
        return this.strategy.evaluate(string, this.substrings, this.caseStrategy, mismatch);
    }

    public void describeTo(Description description) {
        description.appendText(String.format(EXPECTED_SCENARIO, new Object[]{this.strategy, this.substrings}));
        if (this.caseStrategy != CaseStrategy.DEFAULT) {
            description.appendText(" (").appendText(this.caseStrategy.description).appendText(")");
        }
    }

    protected Strategy getStrategy() {
        return this.strategy;
    }

    protected List<String> getSubstrings() {
        return this.substrings;
    }

    private static enum CaseStrategy {
        DEFAULT("default"){

            @Override
            public boolean contains(String string, String substring) {
                return string != null && substring != null && string.contains(substring);
            }
        }
        ,
        IGNORE_CASE("ignore case"){

            @Override
            public boolean contains(String string, String substring) {
                return string != null && substring != null && string.toLowerCase().contains(substring.toLowerCase());
            }
        };

        String description;

        private CaseStrategy(String description) {
            this.description = description;
        }

        public abstract boolean contains(String var1, String var2);
    }

    protected static enum Strategy {
        ALL{

            @Override
            public boolean evaluate(String string, List<String> substrings, CaseStrategy caseStrategy, Description mismatch) {
                for (String substring : substrings) {
                    if (caseStrategy.contains(string, substring)) continue;
                    mismatch.appendText(String.format(StringMatcher.EXPECTED_STRING_NOT_FOUND, substring, string));
                    return false;
                }
                return true;
            }
        }
        ,
        ANY{

            @Override
            public boolean evaluate(String string, List<String> substrings, CaseStrategy caseStrategy, Description mismatch) {
                for (String substring : substrings) {
                    if (!caseStrategy.contains(string, substring)) continue;
                    return true;
                }
                mismatch.appendText(String.format(StringMatcher.NONE_OF_THE_STRINGS_FOUND, string));
                return false;
            }
        }
        ,
        NONE{

            @Override
            public boolean evaluate(String string, List<String> substrings, CaseStrategy caseStrategy, Description mismatch) {
                for (String substring : substrings) {
                    if (!caseStrategy.contains(string, substring)) continue;
                    mismatch.appendText(String.format(StringMatcher.UNEXPECTED_STRING_FOUND, substring, string));
                    return false;
                }
                return true;
            }
        };


        public abstract boolean evaluate(String var1, List<String> var2, CaseStrategy var3, Description var4);
    }
}

