/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.junit.utils.matchers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class ExceptionMatcher
extends TypeSafeDiagnosingMatcher<Runnable> {
    private static final String NEW_LINE_INDENT = "\n          ";
    private final Class<? extends Exception> expectedException;
    private Class<? extends Throwable> expectedCause;
    private boolean checkCauseFlag = false;
    private boolean checkMessageFlag = false;
    private MessageMatchingStrategy messageMatchingStrategy;
    private List<String> expectedMessageSubstrings = Collections.emptyList();
    private Matcher<String> messageMatcher;

    private ExceptionMatcher(Class<? extends Exception> expectedException) {
        this.expectedException = expectedException;
    }

    @Factory
    public static ExceptionMatcher throwsException() {
        return new ExceptionMatcher(Exception.class);
    }

    @Factory
    public static ExceptionMatcher throwsException(Class<? extends Exception> exception) {
        return new ExceptionMatcher(exception);
    }

    @Factory
    public static Matcher<Runnable> throwsNoException() {
        return new ExceptionMatcher(null);
    }

    public ExceptionMatcher withCause(Class<? extends Throwable> cause) {
        this.expectedCause = cause;
        this.checkCauseFlag = true;
        return this;
    }

    public ExceptionMatcher withMessage(Matcher<String> matcher) {
        this.messageMatcher = matcher;
        this.checkMessageFlag = true;
        this.messageMatchingStrategy = MessageMatchingStrategy.EXTERNAL_MATCHER;
        return this;
    }

    public ExceptionMatcher withMessage(String message) {
        return this.withMessage((Matcher<String>)CoreMatchers.equalTo((Object)message));
    }

    public ExceptionMatcher withMessageContaining(String ... substrings) {
        if (substrings != null) {
            this.expectedMessageSubstrings = Arrays.asList(substrings);
        }
        this.checkMessageFlag = true;
        this.messageMatchingStrategy = MessageMatchingStrategy.EXPECTED_SUBSTRINGS;
        return this;
    }

    protected boolean matchesSafely(Runnable runnable, Description mismatch) {
        try {
            runnable.run();
            mismatch.appendText(NEW_LINE_INDENT).appendText("no exception was thrown");
            return this.expectedException == null;
        }
        catch (Exception exception) {
            return this.validateFully(exception, mismatch);
        }
    }

    protected boolean validateFully(Throwable throwable, Description mismatch) {
        if (!this.validateException(throwable, mismatch)) {
            return false;
        }
        if (this.checkMessageFlag && !this.validateMessage(throwable, mismatch)) {
            return false;
        }
        return !this.checkCauseFlag || this.validateCause(throwable, mismatch);
    }

    private boolean validateException(Throwable throwable, Description mismatch) {
        if (this.expectedException == null || !this.expectedException.isAssignableFrom(throwable.getClass())) {
            mismatch.appendText(NEW_LINE_INDENT).appendText("was ").appendText(ExceptionMatcher.nullSafeClassNameToText(throwable.getClass()));
            return false;
        }
        return true;
    }

    private boolean validateMessage(Throwable throwable, Description mismatch) {
        return this.messageMatchingStrategy.validateMessage(this, throwable, mismatch);
    }

    private boolean validateCause(Throwable throwable, Description mismatch) {
        Throwable cause = throwable.getCause();
        if (cause == null && this.expectedCause != null) {
            mismatch.appendText(NEW_LINE_INDENT).appendText("the cause was null");
            return false;
        }
        if (!(cause == null || this.expectedCause != null && this.expectedCause.isAssignableFrom(cause.getClass()))) {
            mismatch.appendText(NEW_LINE_INDENT).appendText("the cause was: ").appendText(ExceptionMatcher.nullSafeClassNameToText(cause.getClass()));
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText(NEW_LINE_INDENT).appendText(ExceptionMatcher.nullSafeClassNameToText(this.expectedException));
        if (this.checkMessageFlag) {
            this.messageMatchingStrategy.describeTo(this, description);
        }
        if (this.checkCauseFlag) {
            description.appendText(NEW_LINE_INDENT).appendText("and cause: ").appendText(ExceptionMatcher.nullSafeClassNameToText(this.expectedCause));
        }
    }

    private static String nullSafeClassNameToText(Class<?> clazz) {
        return clazz != null ? clazz.getCanonicalName() : "no exception";
    }

    protected Class<? extends Exception> getExpectedException() {
        return this.expectedException;
    }

    private static enum MessageMatchingStrategy {
        EXPECTED_SUBSTRINGS{

            @Override
            boolean validateMessage(ExceptionMatcher parent, Throwable throwable, Description mismatch) {
                String message = throwable.getMessage();
                if (message == null) {
                    if (parent.expectedMessageSubstrings.isEmpty()) {
                        return true;
                    }
                    mismatch.appendText(ExceptionMatcher.NEW_LINE_INDENT).appendText("the message was null");
                    return false;
                }
                for (String substring : parent.expectedMessageSubstrings) {
                    if (message.contains(substring)) continue;
                    mismatch.appendText(ExceptionMatcher.NEW_LINE_INDENT).appendText("the message was ").appendValue((Object)message);
                    return false;
                }
                return true;
            }

            @Override
            void describeTo(ExceptionMatcher parent, Description description) {
                description.appendText(ExceptionMatcher.NEW_LINE_INDENT).appendText("with message containing: ").appendText(parent.expectedMessageSubstrings.toString());
            }
        }
        ,
        EXTERNAL_MATCHER{

            @Override
            boolean validateMessage(ExceptionMatcher parent, Throwable throwable, Description mismatch) {
                String message = throwable.getMessage();
                if (message == null && parent.messageMatcher == null) {
                    return true;
                }
                if (parent.messageMatcher == null) {
                    mismatch.appendText(ExceptionMatcher.NEW_LINE_INDENT).appendText("the message was ").appendValue((Object)message);
                    return false;
                }
                boolean matcherResult = parent.messageMatcher.matches((Object)message);
                if (!matcherResult) {
                    mismatch.appendText(ExceptionMatcher.NEW_LINE_INDENT).appendText("the message ");
                    parent.messageMatcher.describeMismatch((Object)message, mismatch);
                }
                return matcherResult;
            }

            @Override
            void describeTo(ExceptionMatcher parent, Description description) {
                description.appendText(ExceptionMatcher.NEW_LINE_INDENT).appendText("with message: ");
                if (parent.messageMatcher != null) {
                    parent.messageMatcher.describeTo(description);
                } else {
                    description.appendText("<null>");
                }
            }
        };


        abstract boolean validateMessage(ExceptionMatcher var1, Throwable var2, Description var3);

        abstract void describeTo(ExceptionMatcher var1, Description var2);
    }
}

