/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.junit.utils.matchers;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class InstantiationNotAllowedMatcher
extends TypeSafeDiagnosingMatcher<Class<?>> {
    @Factory
    public static Matcher<Class<?>> instantiationNotAllowed() {
        return new InstantiationNotAllowedMatcher();
    }

    protected boolean matchesSafely(Class<?> clazz, Description mismatch) {
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (Modifier.isPrivate(constructor.getModifiers())) continue;
            mismatch.appendText("the constructor \"" + constructor + "\" is not private");
            return false;
        }
        return this.checkInstantiationNotAllowed(clazz, mismatch);
    }

    private boolean checkInstantiationNotAllowed(Class<?> clazz, Description mismatch) {
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            constructor.newInstance(new Object[0]);
            mismatch.appendText("instantiation via Reflection was allowed by the constructor \"" + constructor + "\"");
            return false;
        }
        catch (ReflectiveOperationException exception) {
            return true;
        }
    }

    public void describeTo(Description description) {
        description.appendText("a class which cannot be instantiated");
    }
}

