/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.junit.utils.matchers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class ExceptionMatcher
extends TypeSafeDiagnosingMatcher<Runnable> {
    private static final String NEW_LINE_INDENT = "\n          ";
    private final Class<? extends Exception> expectedException;
    private boolean checkCauseFlag = false;
    private boolean checkMessageFlag = false;
    private Class<? extends Throwable> expectedCause;
    private List<String> expectedMessageSubstrings = Collections.emptyList();

    private ExceptionMatcher(Class<? extends Exception> expectedException) {
        this.expectedException = expectedException;
    }

    @Factory
    public static ExceptionMatcher throwsException(Class<? extends Exception> exception) {
        return new ExceptionMatcher(exception);
    }

    public ExceptionMatcher withCause(Class<? extends Throwable> cause) {
        this.expectedCause = cause;
        this.checkCauseFlag = true;
        return this;
    }

    public ExceptionMatcher withMessageContaining(String ... substrings) {
        if (substrings != null) {
            this.expectedMessageSubstrings = Arrays.asList(substrings);
        }
        this.checkMessageFlag = true;
        return this;
    }

    protected boolean matchesSafely(Runnable runnable, Description mismatch) {
        try {
            runnable.run();
            mismatch.appendText(NEW_LINE_INDENT).appendText("no exception was thrown");
            return this.expectedException == null;
        }
        catch (Exception exception) {
            return this.validateFully(exception, mismatch);
        }
    }

    private boolean validateFully(Exception exception, Description mismatch) {
        if (!this.validateException(exception, mismatch)) {
            return false;
        }
        if (this.checkMessageFlag && !this.expectedMessageSubstrings.isEmpty() && !this.validateMessage(exception, mismatch)) {
            return false;
        }
        return !this.checkCauseFlag || this.validateCause(exception, mismatch);
    }

    private boolean validateException(Exception exception, Description mismatch) {
        if (this.expectedException == null || !this.expectedException.isAssignableFrom(exception.getClass())) {
            mismatch.appendText(NEW_LINE_INDENT).appendText("was ").appendText(this.nullSafeClassNameToText(exception.getClass()));
            return false;
        }
        return true;
    }

    private boolean validateMessage(Exception exception, Description mismatch) {
        String message = exception.getMessage();
        if (message == null) {
            mismatch.appendText(NEW_LINE_INDENT).appendText("the message was null");
            return false;
        }
        for (String substring : this.expectedMessageSubstrings) {
            if (message.contains(substring)) continue;
            mismatch.appendText(NEW_LINE_INDENT).appendText("the message was ").appendValue((Object)message);
            return false;
        }
        return true;
    }

    private boolean validateCause(Exception exception, Description mismatch) {
        Throwable cause = exception.getCause();
        if (cause == null && this.expectedCause != null) {
            mismatch.appendText(NEW_LINE_INDENT).appendText("the cause was null");
            return false;
        }
        if (!(cause == null || this.expectedCause != null && this.expectedCause.isAssignableFrom(cause.getClass()))) {
            mismatch.appendText(NEW_LINE_INDENT).appendText("the cause was: ").appendText(this.nullSafeClassNameToText(cause.getClass()));
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText(NEW_LINE_INDENT).appendText(this.nullSafeClassNameToText(this.expectedException));
        if (this.checkMessageFlag) {
            description.appendText(NEW_LINE_INDENT).appendText("and message containing: ").appendText(this.expectedMessageSubstrings.toString());
        }
        if (this.checkCauseFlag) {
            description.appendText(NEW_LINE_INDENT).appendText("and cause: ").appendText(this.nullSafeClassNameToText(this.expectedCause));
        }
    }

    private String nullSafeClassNameToText(Class<?> clazz) {
        return clazz != null ? clazz.getCanonicalName() : "null";
    }
}

