/*
 * Decompiled with CFR 0.152.
 */
package net.obvj.junit.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.function.Supplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class TestUtils {
    protected static final String EXPECTED_BUT_NOT_THROWN = "Expected but not thrown: \"%s\"";
    private static final String EXPECTED_STRING_NOT_FOUND = "Expected string \"%s\" not found in: \"%s\"";
    private static final String UNEXPECTED_STRING_FOUND = "Unexpected string \"%s\" found in: \"%s\"";

    private TestUtils() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void assertNoInstancesAllowed(Class<?> targetClass) throws ReflectiveOperationException {
        TestUtils.assertNoInstancesAllowed(targetClass, null);
    }

    public static void assertNoInstancesAllowed(Class<?> targetClass, Class<? extends Throwable> expectedThrowableClass) throws ReflectiveOperationException {
        TestUtils.assertNoInstancesAllowed(targetClass, expectedThrowableClass, null);
    }

    public static void assertNoInstancesAllowed(Class<?> targetClass, Class<? extends Throwable> expectedThrowableClass, String expectedErrorMessage) throws ReflectiveOperationException {
        try {
            Constructor<?> constructor = targetClass.getDeclaredConstructor(new Class[0]);
            Assert.assertTrue((String)"Constructor should be private", (boolean)Modifier.isPrivate(constructor.getModifiers()));
            constructor.setAccessible(true);
            constructor.newInstance(new Object[0]);
            throw new AssertionError((Object)"Class was instantiated");
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (expectedThrowableClass != null) {
                Assert.assertThat((Object)cause, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(expectedThrowableClass)));
            }
            if (expectedErrorMessage != null) {
                Assert.assertThat((Object)cause.getMessage(), (Matcher)CoreMatchers.is((Object)expectedErrorMessage));
            }
            return;
        }
    }

    public static void assertException(Class<? extends Throwable> expectedThrowable, Throwable throwable) {
        TestUtils.assertException(expectedThrowable, null, null, throwable);
    }

    public static void assertException(Class<? extends Throwable> expectedThrowable, String expectedMessage, Throwable throwable) {
        TestUtils.assertException(expectedThrowable, expectedMessage, null, throwable);
    }

    public static void assertException(Class<? extends Throwable> expectedThrowable, String expectedMessage, Class<? extends Throwable> expectedCause, Throwable throwable) {
        Assert.assertThat((String)"Unexpected throwable class:", (Object)throwable, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(expectedThrowable)));
        if (expectedMessage != null) {
            Assert.assertThat((String)"Unexpected message:", (Object)throwable.getMessage(), (Matcher)CoreMatchers.is((Object)expectedMessage));
        }
        if (expectedCause != null) {
            Assert.assertThat((String)"Unexpected cause:", (Object)throwable.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(expectedCause)));
        }
    }

    public static void assertException(Class<? extends Throwable> expectedThrowable, Supplier<?> supplier) {
        TestUtils.assertException(expectedThrowable, null, null, supplier);
    }

    public static void assertException(Class<? extends Throwable> expectedThrowable, String expectedMessage, Supplier<?> supplier) {
        TestUtils.assertException(expectedThrowable, expectedMessage, null, supplier);
    }

    public static void assertException(Class<? extends Throwable> expectedThrowable, String expectedMessage, Class<? extends Throwable> expectedCause, Supplier<?> supplier) {
        try {
            supplier.get();
        }
        catch (Throwable throwable) {
            TestUtils.assertException(expectedThrowable, expectedMessage, expectedCause, throwable);
            return;
        }
        throw new AssertionError((Object)String.format(EXPECTED_BUT_NOT_THROWN, expectedThrowable.getCanonicalName()));
    }

    public static void assertException(Class<? extends Throwable> expectedThrowable, Runnable runnable) {
        TestUtils.assertException(expectedThrowable, null, null, runnable);
    }

    public static void assertException(Class<? extends Throwable> expectedThrowable, String expectedMessage, Runnable runnable) {
        TestUtils.assertException(expectedThrowable, expectedMessage, null, runnable);
    }

    public static void assertException(Class<? extends Throwable> expectedThrowable, String expectedMessage, Class<? extends Throwable> expectedCause, Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            TestUtils.assertException(expectedThrowable, expectedMessage, expectedCause, throwable);
            return;
        }
        throw new AssertionError((Object)String.format(EXPECTED_BUT_NOT_THROWN, expectedThrowable.getCanonicalName()));
    }

    public static void assertStringContains(String testString, String ... expectedStrings) {
        Arrays.stream(expectedStrings).forEach(expectedString -> Assert.assertTrue((String)String.format(EXPECTED_STRING_NOT_FOUND, expectedString, testString), (boolean)testString.contains((CharSequence)expectedString)));
    }

    public static void assertStringDoesNotContain(String testString, String ... expectedStrings) {
        Arrays.stream(expectedStrings).forEach(expectedString -> Assert.assertFalse((String)String.format(UNEXPECTED_STRING_FOUND, expectedString, testString), (boolean)testString.contains((CharSequence)expectedString)));
    }
}

